/* protFeat.c was originally generated by the autoSql program, which also 
 * generated protFeat.h and protFeat.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "protFeat.h"


void protFeatStaticLoad(char **row, struct protFeat *ret)
/* Load a row from protFeat table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->protein = row[0];
ret->start = sqlSigned(row[1]);
ret->end = sqlSigned(row[2]);
ret->feature = row[3];
ret->score = sqlDouble(row[4]);
}

struct protFeat *protFeatLoad(char **row)
/* Load a protFeat from row fetched with select * from protFeat
 * from database.  Dispose of this with protFeatFree(). */
{
struct protFeat *ret;

AllocVar(ret);
ret->protein = cloneString(row[0]);
ret->start = sqlSigned(row[1]);
ret->end = sqlSigned(row[2]);
ret->feature = cloneString(row[3]);
ret->score = sqlDouble(row[4]);
return ret;
}

struct protFeat *protFeatLoadAll(char *fileName) 
/* Load all protFeat from a whitespace-separated file.
 * Dispose of this with protFeatFreeList(). */
{
struct protFeat *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = protFeatLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct protFeat *protFeatLoadAllByChar(char *fileName, char chopper) 
/* Load all protFeat from a chopper separated file.
 * Dispose of this with protFeatFreeList(). */
{
struct protFeat *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = protFeatLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct protFeat *protFeatCommaIn(char **pS, struct protFeat *ret)
/* Create a protFeat out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new protFeat */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->protein = sqlStringComma(&s);
ret->start = sqlSignedComma(&s);
ret->end = sqlSignedComma(&s);
ret->feature = sqlStringComma(&s);
ret->score = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void protFeatFree(struct protFeat **pEl)
/* Free a single dynamically allocated protFeat such as created
 * with protFeatLoad(). */
{
struct protFeat *el;

if ((el = *pEl) == NULL) return;
freeMem(el->protein);
freeMem(el->feature);
freez(pEl);
}

void protFeatFreeList(struct protFeat **pList)
/* Free a list of dynamically allocated protFeat's */
{
struct protFeat *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    protFeatFree(&el);
    }
*pList = NULL;
}

void protFeatOutput(struct protFeat *el, FILE *f, char sep, char lastSep) 
/* Print out protFeat.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->protein);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->start);
fputc(sep,f);
fprintf(f, "%d", el->end);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->feature);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->score);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

