# knownCanonical.sql was originally generated by the autoSql program, which also 
# generated knownCanonical.c and knownCanonical.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Describes the canonical splice variant of a gene
CREATE TABLE knownCanonical (
    chrom varchar(255) not null,	# Chromosome
    chromStart int not null,	# Start position (0 based). Represents transcription start for + strand genes, end for - strand genes
    chromEnd int not null,	# End position (non-inclusive). Represents transcription end for + strand genes, start for - strand genes
    clusterId int not null,	# Which cluster of transcripts this belongs to in knownIsoforms
    transcript varchar(255) not null,	# Corresponds to knownGene name field.
    protein varchar(255) not null,	# Accession of the associated protein, or UCSC ID in newer tables.
              #Indices
    UNIQUE(clusterId),
    INDEX(transcript),
    INDEX(protein)
);
