/* kgXref.c was originally generated by the autoSql program, which also 
 * generated kgXref.h and kgXref.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "kgXref.h"


void kgXrefStaticLoad(char **row, struct kgXref *ret)
/* Load a row from kgXref table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->kgID = row[0];
ret->mRNA = row[1];
ret->spID = row[2];
ret->spDisplayID = row[3];
ret->geneSymbol = row[4];
ret->refseq = row[5];
ret->protAcc = row[6];
ret->description = row[7];
ret->rfamAcc = row[8];
ret->tRnaName = row[9];
}

struct kgXref *kgXrefLoad(char **row)
/* Load a kgXref from row fetched with select * from kgXref
 * from database.  Dispose of this with kgXrefFree(). */
{
struct kgXref *ret;

AllocVar(ret);
ret->kgID = cloneString(row[0]);
ret->mRNA = cloneString(row[1]);
ret->spID = cloneString(row[2]);
ret->spDisplayID = cloneString(row[3]);
ret->geneSymbol = cloneString(row[4]);
ret->refseq = cloneString(row[5]);
ret->protAcc = cloneString(row[6]);
ret->description = cloneString(row[7]);
ret->rfamAcc = cloneString(row[8]);
ret->tRnaName = cloneString(row[9]);
return ret;
}

struct kgXref *kgXrefLoadAll(char *fileName) 
/* Load all kgXref from a whitespace-separated file.
 * Dispose of this with kgXrefFreeList(). */
{
struct kgXref *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = kgXrefLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct kgXref *kgXrefLoadAllByChar(char *fileName, char chopper) 
/* Load all kgXref from a chopper separated file.
 * Dispose of this with kgXrefFreeList(). */
{
struct kgXref *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = kgXrefLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct kgXref *kgXrefCommaIn(char **pS, struct kgXref *ret)
/* Create a kgXref out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new kgXref */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->kgID = sqlStringComma(&s);
ret->mRNA = sqlStringComma(&s);
ret->spID = sqlStringComma(&s);
ret->spDisplayID = sqlStringComma(&s);
ret->geneSymbol = sqlStringComma(&s);
ret->refseq = sqlStringComma(&s);
ret->protAcc = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->rfamAcc = sqlStringComma(&s);
ret->tRnaName = sqlStringComma(&s);
*pS = s;
return ret;
}

void kgXrefFree(struct kgXref **pEl)
/* Free a single dynamically allocated kgXref such as created
 * with kgXrefLoad(). */
{
struct kgXref *el;

if ((el = *pEl) == NULL) return;
freeMem(el->kgID);
freeMem(el->mRNA);
freeMem(el->spID);
freeMem(el->spDisplayID);
freeMem(el->geneSymbol);
freeMem(el->refseq);
freeMem(el->protAcc);
freeMem(el->description);
freeMem(el->rfamAcc);
freeMem(el->tRnaName);
freez(pEl);
}

void kgXrefFreeList(struct kgXref **pList)
/* Free a list of dynamically allocated kgXref's */
{
struct kgXref *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    kgXrefFree(&el);
    }
*pList = NULL;
}

void kgXrefOutput(struct kgXref *el, FILE *f, char sep, char lastSep) 
/* Print out kgXref.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->kgID);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mRNA);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->spID);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->spDisplayID);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneSymbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->refseq);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->protAcc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rfamAcc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tRnaName);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

