# gv.sql was originally generated by the autoSql program, which also 
# generated gv.c and gv.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#track for mutation data
CREATE TABLE hgFixed.gv (
    id varchar(48) not null,	# unique ID for this mutation
    name varchar(255) not null,	# Official nomenclature description of mutation
    srcId varchar(48) not null,	# source ID for this mutation
    baseChangeType enum(
	'insertion', 
	'deletion', 
	'substitution',
	'duplication',
	'complex',
	'unknown') DEFAULT 'unknown' not null,
    location enum(
	'intron', 
	'exon', 
	'5'' UTR', 
	'3'' UTR', 
	'not within known transcription unit') not null, 
    coordinateAccuracy tinyint unsigned not null,	# 0=estimated, 1=definite, others?
              #Indices
    PRIMARY KEY(id)
);

#location of mutation
CREATE TABLE gvPos (
    bin smallint unsigned not null,	# A field to speed indexing
    chrom varchar(255) not null,	# Chromosome
    chromStart int unsigned not null,	# Start position in chrom
    chromEnd int unsigned not null,	# End position in chrom
    name varchar(48) not null,	# ID for this mutation
    strand char(1) not null,	# + or -
    label varchar(64) not null,	# short official name for this mutation
              #Indices
    INDEX(bin)
);

#sources for mutation track
CREATE TABLE hgFixed.gvSrc (
    srcId varchar(48) not null,	# key into gv table
    src varchar(255) not null,	# name of genome wide source or LSDB
    lsdb varchar(255) not null,	# for LSDB name of actual source DB
              #Indices
    PRIMARY KEY(srcId)
);

#attributes asssociated with the mutation
CREATE TABLE hgFixed.gvAttr (
    id varchar(48) not null,	# mutation ID
    attrType varchar(48) not null,	# attribute type
    attrVal varchar(255) not null,	# value for this attribute
              #Indices
    INDEX(id, attrType)
);

#links both urls and local table lookups
CREATE TABLE hgFixed.gvLink (
    id varchar(48) not null,	# id for attribute link
    attrType varchar(48) not null,	# attribute type
    raKey varchar(48) not null,	# key into .ra file on how to do link
    acc varchar(255) not null,	# accession or id used by link
    displayVal varchar(255) not null,	# value to display if different from acc
              #Indices
    INDEX(id, attrType)
);

#attributes associated with a mutation that need long text
CREATE TABLE hgFixed.gvAttrLong (
    id varchar(48) not null,	# mutation ID
    attrType varchar(48) not null,	# attribute type
    attrVal longblob not null,	# value for this attribute
              #Indices
    INDEX(id, attrType)
);
