table dhcHumDerDenAnc
"Human Derived, Denisova Ancestral variants and functional effect predictions from high-coverage Denisova sequencing project"
    (
    string chrom;        "Reference sequence chromosome"
    uint   chromStart;   "Start position in chromosome"
    uint   chromEnd;     "End position in chromosome"
    string name;         "Human allele / Denisova ancestral allele"
    string feature;      "Ensembl Transcript ID or Regulatory Region ID<BR>or ID of TFB profile from JASPAR or TRANSFAC"
    string gene;         "Ensembl Gene ID"
    string extra;        "Extra info: for coding genes, Ensembl Protein ID and/or HGNC;<BR> for Regulatory Motifs, scores & matrix ID"
    string consequence;  "Variant Effect Predictor (VEP) consequence term"
    string cdnaPosition; "Offset in transcript, if applicable"
    string cdsPosition;  "Offset in coding sequence (CDS), if applicable"
    string protPosition; "Offset in protein sequence, if applicable"
    string aminoAcids;   "Amino acid change, if applicable"
    string codons;       "Codon change, if applicable"
    string humanAl;      "Modern human fixed (or major) allele on positive strand"
    string denAl;        "Denisova (ancestral) allele"
    string chimpAl;      "Chimpanzee ancestral allele"
    string gorAl;        "Gorilla ancestral allele"
    string orangAl;      "Orangutan ancestral allele"
    string denZyg;       "Denisova zygosity of ancestral allele (homozygous/heterozygous)"
    string dbSNP;        "dbSNP rs ID, if available"
    float tgpFreq;       "1000 Genomes Project frequency of modern human allele"
    string flag;         "Flag(s): CpG if in CpG island; RM if in repeat masked region;<BR> LowQual if conflicting GATK calls; SysErr if prone to systematic errors"
    char geneStrand;     "Gene strand: '+' or '-', if applicable; otherwise '.'"
    )
