table dbNsfpLrt
"LRT scores provided by dbNSFP (http://dbnsfp.houstonbioinformatics.org/)"
    (
    string chrom;      "Reference sequence chromosome or scaffold"
    uint   chromStart; "Start position in chromosome"
    uint   chromEnd;   "End position in chromosome"
    enum('A','C','G','T','.') refAl;  "Allele found in reference assembly"
    lstring ensTxId;   "Ensembl transcript ID(s), if dbNSFP has data for >1 transcript set at this position; otherwise '.' to save space"
    enum('A','C','G','T') altAl1;     "alternate allele #1"
    string score1;                    "Likelihood Ratio Test p-value for altAl1, or '.' if n/a"
    enum('D','N','U','.') pred1;      "Prediction for altAl1: Damaging, Neutral, Unknown, n/a"
    string omega1;                    "Omega (est. NS:Syn ratio) for altAl1, or '.' if n/a"
    enum('A','C','G','T','.') altAl2; "alternate allele #2"
    string score2;                    "Likelihood Ratio Test p-value for altAl2, or '.' if n/a"
    enum('D','N','U','.') pred2;      "Prediction for altAl2: Damaging, Neutral, Unknown, n/a"
    string omega2;                    "Omega (est. NS:Syn ratio) for altAl2, or '.' if n/a"
    enum('A','C','G','T','.') altAl3; "alternate allele #3"
    string score3;                    "Likelihood Ratio Test p-value for altAl3, or '.' if n/a"
    enum('D','N','U','.') pred3;      "Prediction for altAl3: Damaging, Neutral, Unknown, n/a"
    string omega3;                    "Omega (est. NS:Syn ratio) for altAl3, or '.' if n/a"
    )
