/* bigLink.c was originally generated by the autoSql program, which also 
 * generated bigLink.h and bigLink.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bigLink.h"



char *bigLinkCommaSepFieldNames = "chrom,chromStart,chromEnd,name,qStart";

void bigLinkStaticLoad(char **row, struct bigLink *ret)
/* Load a row from bigLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->qStart = sqlUnsigned(row[4]);
}

struct bigLink *bigLinkLoad(char **row)
/* Load a bigLink from row fetched with select * from bigLink
 * from database.  Dispose of this with bigLinkFree(). */
{
struct bigLink *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->qStart = sqlUnsigned(row[4]);
return ret;
}

struct bigLink *bigLinkLoadAll(char *fileName) 
/* Load all bigLink from a whitespace-separated file.
 * Dispose of this with bigLinkFreeList(). */
{
struct bigLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = bigLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bigLink *bigLinkLoadAllByChar(char *fileName, char chopper) 
/* Load all bigLink from a chopper separated file.
 * Dispose of this with bigLinkFreeList(). */
{
struct bigLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bigLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bigLink *bigLinkCommaIn(char **pS, struct bigLink *ret)
/* Create a bigLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bigLink */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->qStart = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void bigLinkFree(struct bigLink **pEl)
/* Free a single dynamically allocated bigLink such as created
 * with bigLinkLoad(). */
{
struct bigLink *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void bigLinkFreeList(struct bigLink **pList)
/* Free a list of dynamically allocated bigLink's */
{
struct bigLink *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bigLinkFree(&el);
    }
*pList = NULL;
}

void bigLinkOutput(struct bigLink *el, FILE *f, char sep, char lastSep) 
/* Print out bigLink.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->qStart);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

int bigLinkCmpTarget(const void *va, const void *vb)
/* Compare to sort based on target position. */
{
const struct bigLink *a = *((struct bigLink **)va);
const struct bigLink *b = *((struct bigLink **)vb);
int dif = strcmp(a->chrom, b->chrom);
if (dif == 0)
    dif = a->chromStart - b->chromStart;
return dif;
}

