/* bdgpSwissProt.c was originally generated by the autoSql program, which also 
 * generated bdgpSwissProt.h and bdgpSwissProt.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bdgpSwissProt.h"


void bdgpSwissProtStaticLoad(char **row, struct bdgpSwissProt *ret)
/* Load a row from bdgpSwissProt table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
int sizeOne,i;
char *s;

ret->bdgpName = row[0];
ret->flyBaseId = row[1];
ret->go = row[2];
ret->symbol = row[3];
ret->cytorange = row[4];
ret->swissProtId = row[5];
ret->spGeneName = row[6];
ret->spSymbol = row[7];
}

struct bdgpSwissProt *bdgpSwissProtLoad(char **row)
/* Load a bdgpSwissProt from row fetched with select * from bdgpSwissProt
 * from database.  Dispose of this with bdgpSwissProtFree(). */
{
struct bdgpSwissProt *ret;
int sizeOne,i;
char *s;

AllocVar(ret);
ret->bdgpName = cloneString(row[0]);
ret->flyBaseId = cloneString(row[1]);
ret->go = cloneString(row[2]);
ret->symbol = cloneString(row[3]);
ret->cytorange = cloneString(row[4]);
ret->swissProtId = cloneString(row[5]);
ret->spGeneName = cloneString(row[6]);
ret->spSymbol = cloneString(row[7]);
return ret;
}

struct bdgpSwissProt *bdgpSwissProtLoadAll(char *fileName) 
/* Load all bdgpSwissProt from a whitespace-separated file.
 * Dispose of this with bdgpSwissProtFreeList(). */
{
struct bdgpSwissProt *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = bdgpSwissProtLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bdgpSwissProt *bdgpSwissProtLoadAllByChar(char *fileName, char chopper) 
/* Load all bdgpSwissProt from a chopper separated file.
 * Dispose of this with bdgpSwissProtFreeList(). */
{
struct bdgpSwissProt *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bdgpSwissProtLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bdgpSwissProt *bdgpSwissProtCommaIn(char **pS, struct bdgpSwissProt *ret)
/* Create a bdgpSwissProt out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bdgpSwissProt */
{
char *s = *pS;
int i;

if (ret == NULL)
    AllocVar(ret);
ret->bdgpName = sqlStringComma(&s);
ret->flyBaseId = sqlStringComma(&s);
ret->go = sqlStringComma(&s);
ret->symbol = sqlStringComma(&s);
ret->cytorange = sqlStringComma(&s);
ret->swissProtId = sqlStringComma(&s);
ret->spGeneName = sqlStringComma(&s);
ret->spSymbol = sqlStringComma(&s);
*pS = s;
return ret;
}

void bdgpSwissProtFree(struct bdgpSwissProt **pEl)
/* Free a single dynamically allocated bdgpSwissProt such as created
 * with bdgpSwissProtLoad(). */
{
struct bdgpSwissProt *el;

if ((el = *pEl) == NULL) return;
freeMem(el->bdgpName);
freeMem(el->flyBaseId);
freeMem(el->go);
freeMem(el->symbol);
freeMem(el->cytorange);
freeMem(el->swissProtId);
freeMem(el->spGeneName);
freeMem(el->spSymbol);
freez(pEl);
}

void bdgpSwissProtFreeList(struct bdgpSwissProt **pList)
/* Free a list of dynamically allocated bdgpSwissProt's */
{
struct bdgpSwissProt *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bdgpSwissProtFree(&el);
    }
*pList = NULL;
}

void bdgpSwissProtOutput(struct bdgpSwissProt *el, FILE *f, char sep, char lastSep) 
/* Print out bdgpSwissProt.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->bdgpName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->flyBaseId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->go);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->symbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cytorange);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->swissProtId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->spGeneName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->spSymbol);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

