/* arCOGs.c was originally generated by the autoSql program, which also 
 * generated arCOGs.h and arCOGs.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "arCOGs.h"


void arCOGsStaticLoad(char **row, struct arCOGs *ret)
/* Load a row from arCOGs table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->gene = row[6];
}

struct arCOGs *arCOGsLoad(char **row)
/* Load a arCOGs from row fetched with select * from arCOGs
 * from database.  Dispose of this with arCOGsFree(). */
{
struct arCOGs *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->gene = cloneString(row[6]);
return ret;
}

struct arCOGs *arCOGsLoadAll(char *fileName) 
/* Load all arCOGs from a whitespace-separated file.
 * Dispose of this with arCOGsFreeList(). */
{
struct arCOGs *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = arCOGsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct arCOGs *arCOGsLoadAllByChar(char *fileName, char chopper) 
/* Load all arCOGs from a chopper separated file.
 * Dispose of this with arCOGsFreeList(). */
{
struct arCOGs *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = arCOGsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct arCOGs *arCOGsCommaIn(char **pS, struct arCOGs *ret)
/* Create a arCOGs out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new arCOGs */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->gene = sqlStringComma(&s);
*pS = s;
return ret;
}

void arCOGsFree(struct arCOGs **pEl)
/* Free a single dynamically allocated arCOGs such as created
 * with arCOGsLoad(). */
{
struct arCOGs *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->gene);
freez(pEl);
}

void arCOGsFreeList(struct arCOGs **pList)
/* Free a list of dynamically allocated arCOGs's */
{
struct arCOGs *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    arCOGsFree(&el);
    }
*pList = NULL;
}

void arCOGsOutput(struct arCOGs *el, FILE *f, char sep, char lastSep) 
/* Print out arCOGs.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gene);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

