/* allpredictions.c was originally generated by the autoSql program, which also 
 * generated allpredictions.h and allpredictions.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "allpredictions.h"


void allpredictionsStaticLoad(char **row, struct allpredictions *ret)
/* Load a row from allpredictions table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->source = row[6];
}

struct allpredictions *allpredictionsLoad(char **row)
/* Load a allpredictions from row fetched with select * from allpredictions
 * from database.  Dispose of this with allpredictionsFree(). */
{
struct allpredictions *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->source = cloneString(row[6]);
return ret;
}

struct allpredictions *allpredictionsLoadAll(char *fileName) 
/* Load all allpredictions from a whitespace-separated file.
 * Dispose of this with allpredictionsFreeList(). */
{
struct allpredictions *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = allpredictionsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct allpredictions *allpredictionsLoadAllByChar(char *fileName, char chopper) 
/* Load all allpredictions from a chopper separated file.
 * Dispose of this with allpredictionsFreeList(). */
{
struct allpredictions *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = allpredictionsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct allpredictions *allpredictionsCommaIn(char **pS, struct allpredictions *ret)
/* Create a allpredictions out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new allpredictions */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->source = sqlStringComma(&s);
*pS = s;
return ret;
}

void allpredictionsFree(struct allpredictions **pEl)
/* Free a single dynamically allocated allpredictions such as created
 * with allpredictionsLoad(). */
{
struct allpredictions *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->source);
freez(pEl);
}

void allpredictionsFreeList(struct allpredictions **pList)
/* Free a list of dynamically allocated allpredictions's */
{
struct allpredictions *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    allpredictionsFree(&el);
    }
*pList = NULL;
}

void allpredictionsOutput(struct allpredictions *el, FILE *f, char sep, char lastSep) 
/* Print out allpredictions.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->source);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

