/* txGraph.h was originally generated by the autoSql program, which also 
 * generated txGraph.c and txGraph.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef TXGRAPH_H
#define TXGRAPH_H

#define TXGRAPH_NUM_COLS 11

struct txGraph
/* A transcription graph. Includes alt-splicing info. */
    {
    struct txGraph *next;  /* Next in singly linked list. */
    char *tName;	/* name of target sequence, often a chrom. */
    int tStart;	/* First bac touched by graph. */
    int tEnd;	/* Start position in first bac. */
    char *name;	/* Human readable name. */
    char strand[3];	/* + or - strand. */
    unsigned vertexCount;	/* Number of vertices in graph. */
    struct txVertex *vertices;	/* Splice sites and soft ends. */
    unsigned edgeCount;	/* Number of edges in graph. */
    struct txEdge *edgeList;	/* Edges (introns and exons) in graph. */
    int sourceCount;	/* Number of sources of evidence. */
    struct txSource *sources;	/* Sources of evidence. */
    };

struct txGraph *txGraphLoad(char **row);
/* Load a txGraph from row fetched with select * from txGraph
 * from database.  Dispose of this with txGraphFree(). */

struct txGraph *txGraphLoadAll(char *fileName);
/* Load all txGraph from whitespace-separated file.
 * Dispose of this with txGraphFreeList(). */

struct txGraph *txGraphLoadAllByChar(char *fileName, char chopper);
/* Load all txGraph from chopper separated file.
 * Dispose of this with txGraphFreeList(). */

#define txGraphLoadAllByTab(a) txGraphLoadAllByChar(a, '\t');
/* Load all txGraph from tab separated file.
 * Dispose of this with txGraphFreeList(). */

struct txGraph *txGraphCommaIn(char **pS, struct txGraph *ret);
/* Create a txGraph out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new txGraph */

void txGraphFree(struct txGraph **pEl);
/* Free a single dynamically allocated txGraph such as created
 * with txGraphLoad(). */

void txGraphFreeList(struct txGraph **pList);
/* Free a list of dynamically allocated txGraph's */

void txGraphOutput(struct txGraph *el, FILE *f, char sep, char lastSep);
/* Print out txGraph.  Separate fields with sep. Follow last field with lastSep. */

#define txGraphTabOut(el,f) txGraphOutput(el,f,'\t','\n');
/* Print out txGraph as a line in a tab-separated file. */

#define txGraphCommaOut(el,f) txGraphOutput(el,f,',',',');
/* Print out txGraph as a comma separated list including final comma. */

#define TXVERTEX_NUM_COLS 2

struct txVertex
/* A vertex in a transcription graph - splice site or soft end */
    {
    int position;	/* Vertex position in genomic sequence. */
    unsigned char type;	/* Vertex type - ggSoftStart, ggHardStart, etc. */
    };

struct txVertex *txVertexCommaIn(char **pS, struct txVertex *ret);
/* Create a txVertex out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new txVertex */

void txVertexOutput(struct txVertex *el, FILE *f, char sep, char lastSep);
/* Print out txVertex.  Separate fields with sep. Follow last field with lastSep. */

#define txVertexTabOut(el,f) txVertexOutput(el,f,'\t','\n');
/* Print out txVertex as a line in a tab-separated file. */

#define txVertexCommaOut(el,f) txVertexOutput(el,f,',',',');
/* Print out txVertex as a comma separated list including final comma. */

#define TXEDGE_NUM_COLS 5

struct txEdge
/* An edge in a transcription graph - exon or intron */
    {
    struct txEdge *next;  /* Next in singly linked list. */
    int startIx;	/* Index of start in vertex array */
    int endIx;	/* Index of end in vertex array */
    unsigned char type;	/* Edge type */
    int evCount;	/* Count of evidence */
    struct txEvidence *evList;	/* List of evidence */
    };

struct txEdge *txEdgeCommaIn(char **pS, struct txEdge *ret);
/* Create a txEdge out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new txEdge */

void txEdgeFree(struct txEdge **pEl);
/* Free a single dynamically allocated txEdge such as created
 * with txEdgeLoad(). */

void txEdgeFreeList(struct txEdge **pList);
/* Free a list of dynamically allocated txEdge's */

void txEdgeOutput(struct txEdge *el, FILE *f, char sep, char lastSep);
/* Print out txEdge.  Separate fields with sep. Follow last field with lastSep. */

#define txEdgeTabOut(el,f) txEdgeOutput(el,f,'\t','\n');
/* Print out txEdge as a line in a tab-separated file. */

#define txEdgeCommaOut(el,f) txEdgeOutput(el,f,',',',');
/* Print out txEdge as a comma separated list including final comma. */

#define TXEVIDENCE_NUM_COLS 3

struct txEvidence
/* Information on evidence for an edge. */
    {
    struct txEvidence *next;  /* Next in singly linked list. */
    int sourceId;	/* Id (index) in sources list */
    int start;	/* Start position */
    int end;	/* End position */
    };

struct txEvidence *txEvidenceCommaIn(char **pS, struct txEvidence *ret);
/* Create a txEvidence out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new txEvidence */

void txEvidenceFree(struct txEvidence **pEl);
/* Free a single dynamically allocated txEvidence such as created
 * with txEvidenceLoad(). */

void txEvidenceFreeList(struct txEvidence **pList);
/* Free a list of dynamically allocated txEvidence's */

void txEvidenceOutput(struct txEvidence *el, FILE *f, char sep, char lastSep);
/* Print out txEvidence.  Separate fields with sep. Follow last field with lastSep. */

#define txEvidenceTabOut(el,f) txEvidenceOutput(el,f,'\t','\n');
/* Print out txEvidence as a line in a tab-separated file. */

#define txEvidenceCommaOut(el,f) txEvidenceOutput(el,f,',',',');
/* Print out txEvidence as a comma separated list including final comma. */

#define TXSOURCE_NUM_COLS 2

struct txSource
/* Source of evidence in graph. */
    {
    char *type;	/* Type: refSeq, mrna, est, etc. */
    char *accession;	/* GenBank accession. With type forms a key */
    };

struct txSource *txSourceCommaIn(char **pS, struct txSource *ret);
/* Create a txSource out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new txSource */

void txSourceFreeInternals(struct txSource *array, int count);
/* Free internals of a simple type txSource (one not put on a list). */

void txSourceOutput(struct txSource *el, FILE *f, char sep, char lastSep);
/* Print out txSource.  Separate fields with sep. Follow last field with lastSep. */

#define txSourceTabOut(el,f) txSourceOutput(el,f,'\t','\n');
/* Print out txSource as a line in a tab-separated file. */

#define txSourceCommaOut(el,f) txSourceOutput(el,f,',',',');
/* Print out txSource as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* TXGRAPH_H */

