/* hubSpace.h was originally generated by the autoSql program, which also 
 * generated hubSpace.c and hubSpace.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef HUBSPACE_H
#define HUBSPACE_H

#include "jksql.h"
#define HUBSPACE_NUM_COLS 10

extern char *hubSpaceCommaSepFieldNames;

struct hubSpace
/* file storage table for users to store uploaded tracks */
    {
    struct hubSpace *next;  /* Next in singly linked list. */
    char *userName;	/* userName of user uploading file */
    char *fileName;	/* name of uploaded files. The actual path to this file is different */
    long long fileSize;	/* size of the uploaded file */
    char *fileType;	/* track type of file */
    char *creationTime;	/* first upload time */
    char *lastModified;	/* last change time */
    char *db;	/* genome assembly associated with this file */
    char *location;	/* file system path or URL to file */
    char *md5sum;	/* md5sum of file */
    char *parentDir;	/* parent directory of file */
    };

void hubSpaceStaticLoad(char **row, struct hubSpace *ret);
/* Load a row from hubSpace table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct hubSpace *hubSpaceLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all hubSpace from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with hubSpaceFreeList(). */

void hubSpaceSaveToDb(struct sqlConnection *conn, struct hubSpace *el, char *tableName, int updateSize);
/* Save hubSpace as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct hubSpace *hubSpaceLoad(char **row);
/* Load a hubSpace from row fetched with select * from hubSpace
 * from database.  Dispose of this with hubSpaceFree(). */

struct hubSpace *hubSpaceLoadAll(char *fileName);
/* Load all hubSpace from whitespace-separated file.
 * Dispose of this with hubSpaceFreeList(). */

struct hubSpace *hubSpaceLoadAllByChar(char *fileName, char chopper);
/* Load all hubSpace from chopper separated file.
 * Dispose of this with hubSpaceFreeList(). */

#define hubSpaceLoadAllByTab(a) hubSpaceLoadAllByChar(a, '\t');
/* Load all hubSpace from tab separated file.
 * Dispose of this with hubSpaceFreeList(). */

struct hubSpace *hubSpaceCommaIn(char **pS, struct hubSpace *ret);
/* Create a hubSpace out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hubSpace */

void hubSpaceFree(struct hubSpace **pEl);
/* Free a single dynamically allocated hubSpace such as created
 * with hubSpaceLoad(). */

void hubSpaceFreeList(struct hubSpace **pList);
/* Free a list of dynamically allocated hubSpace's */

void hubSpaceOutput(struct hubSpace *el, FILE *f, char sep, char lastSep);
/* Print out hubSpace.  Separate fields with sep. Follow last field with lastSep. */

#define hubSpaceTabOut(el,f) hubSpaceOutput(el,f,'\t','\n');
/* Print out hubSpace as a line in a tab-separated file. */

#define hubSpaceCommaOut(el,f) hubSpaceOutput(el,f,',',',');
/* Print out hubSpace as a comma separated list including final comma. */

void hubSpaceJsonOutput(struct hubSpace *el, FILE *f);
/* Print out hubSpace in JSON format. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* HUBSPACE_H */

