/* hgnc.h was originally generated by the autoSql program, which also 
 * generated hgnc.c and hgnc.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2012 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef HGNC_H
#define HGNC_H

#define HGNC_NUM_COLS 41

struct hgnc
/* A cross-reference table between HUGO Gene Nomenclature Committee (HGNC) IDs and other database IDs. */
    {
    struct hgnc *next;  /* Next in singly linked list. */
    char *hgncId;	/* HGNC ID */
    char *symbol;	/* Approved Symbol */
    char *name;	/* Approved Name */
    char *status;	/* Status */
    char *locusType;	/* Locus Type */
    char *locusGroup;	/* Locus Group */
    char *prvSymbols;	/* Previous Symbols */
    char *prvNames;	/* Previous Names */
    char *synonyms;	/* Synonyms */
    char *nameSyns;	/* Name synonyms */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    char *dateApprv;	/* Date Approved */
    char *dateMod;	/* Date Modified */
    char *dateSymChange;	/* Date Symbol Changed */
    char *dateNmChange;	/* Date Name Changed */
    char *accession;	/* Accession Numbers */
    char *enzymeIds;	/* Enzyme IDs */
    char *entrezId;	/* Entrez Gene ID */
    char *ensId;	/* Ensembl Gene ID */
    char *mgdId;	/* MGD ID */
    char *miscDbs;	/* Misc Database Links */
    char *miscIds;	/* Misc Database IDs */
    char *pubMed;	/* Pubmed IDs */
    char *refSeqIds;	/* RefSeq IDs */
    char *geneFamilyNm;	/* Gene Family Name */
    char *geneFamilyDesc;	/* Gene Family Description */
    char *recType;	/* Record Type */
    char *primaryId;	/* Primary ID */
    char *secondaryId;	/* Secondary ID */
    char *ccdsId;	/* CCDS ID */
    char *vegaId;	/* Vega ID */
    char *locusDbs;	/* Locus-Specific Databases */
    char *gdbMapped;	/* GDB ID (mapped data) */
    char *entrezMapped;	/* Entrez Gene ID (mapped data) */
    char *omimMapped;	/* OMIM ID (mapped data) */
    char *refSeqMapped;	/* RefSeq (mapped data) */
    char *uniProtMapped;	/* UniProt ID (mapped data) */
    char *ensMapped;	/* ENSEMLB ID (mapped data) */
    char *ucscMapped;	/* UCSC ID (mapped data) */
    char *mgiMapped;	/* MGD ID (mapped data) */
    char *rgdMapped;	/* Rat genome database ID (mapped data) */
    };

void hgncStaticLoadWithNull(char **row, struct hgnc *ret);
/* Load a row from hgnc table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct hgnc *hgncLoadWithNull(char **row);
/* Load a hgnc from row fetched with select * from hgnc
 * from database.  Dispose of this with hgncFree(). */

struct hgnc *hgncLoadAll(char *fileName);
/* Load all hgnc from whitespace-separated file.
 * Dispose of this with hgncFreeList(). */

struct hgnc *hgncLoadAllByChar(char *fileName, char chopper);
/* Load all hgnc from chopper separated file.
 * Dispose of this with hgncFreeList(). */

#define hgncLoadAllByTab(a) hgncLoadAllByChar(a, '\t');
/* Load all hgnc from tab separated file.
 * Dispose of this with hgncFreeList(). */

struct hgnc *hgncCommaIn(char **pS, struct hgnc *ret);
/* Create a hgnc out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hgnc */

void hgncFree(struct hgnc **pEl);
/* Free a single dynamically allocated hgnc such as created
 * with hgncLoad(). */

void hgncFreeList(struct hgnc **pList);
/* Free a list of dynamically allocated hgnc's */

void hgncOutput(struct hgnc *el, FILE *f, char sep, char lastSep);
/* Print out hgnc.  Separate fields with sep. Follow last field with lastSep. */

#define hgncTabOut(el,f) hgncOutput(el,f,'\t','\n');
/* Print out hgnc as a line in a tab-separated file. */

#define hgncCommaOut(el,f) hgncOutput(el,f,',',',');
/* Print out hgnc as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* HGNC_H */

