/* hapmapSnps.h was originally generated by the autoSql program, which also 
 * generated hapmapSnps.c and hapmapSnps.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2009 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef HAPMAPSNPS_H
#define HAPMAPSNPS_H

#define HAPMAPSNPS_NUM_COLS 12

struct hapmapSnps
/* HapMap genotype summary */
    {
    struct hapmapSnps *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom (0 based) */
    unsigned chromEnd;	/* End position in chrom (1 based) */
    char *name;	/* Reference SNP identifier from dbSnp */
    unsigned score;	/* Not used */
    char strand[2];	/* Which genomic strand contains the observed alleles */
    char *observed;	/* Observed string from genotype file */
    char allele1[2];	/* This allele has been observed */
    unsigned homoCount1;	/* Count of individuals who are homozygous for allele1 */
    char *allele2;	/* This allele may not have been observed */
    unsigned homoCount2;	/* Count of individuals who are homozygous for allele2 */
    unsigned heteroCount;	/* Count of individuals who are heterozygous */
    };

void hapmapSnpsStaticLoad(char **row, struct hapmapSnps *ret);
/* Load a row from hapmapSnps table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct hapmapSnps *hapmapSnpsLoad(char **row);
/* Load a hapmapSnps from row fetched with select * from hapmapSnps
 * from database.  Dispose of this with hapmapSnpsFree(). */

struct hapmapSnps *hapmapSnpsLoadAll(char *fileName);
/* Load all hapmapSnps from whitespace-separated file.
 * Dispose of this with hapmapSnpsFreeList(). */

struct hapmapSnps *hapmapSnpsLoadAllByChar(char *fileName, char chopper);
/* Load all hapmapSnps from chopper separated file.
 * Dispose of this with hapmapSnpsFreeList(). */

#define hapmapSnpsLoadAllByTab(a) hapmapSnpsLoadAllByChar(a, '\t');
/* Load all hapmapSnps from tab separated file.
 * Dispose of this with hapmapSnpsFreeList(). */

struct hapmapSnps *hapmapSnpsCommaIn(char **pS, struct hapmapSnps *ret);
/* Create a hapmapSnps out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hapmapSnps */

void hapmapSnpsFree(struct hapmapSnps **pEl);
/* Free a single dynamically allocated hapmapSnps such as created
 * with hapmapSnpsLoad(). */

void hapmapSnpsFreeList(struct hapmapSnps **pList);
/* Free a list of dynamically allocated hapmapSnps's */

void hapmapSnpsOutput(struct hapmapSnps *el, FILE *f, char sep, char lastSep);
/* Print out hapmapSnps.  Separate fields with sep. Follow last field with lastSep. */

#define hapmapSnpsTabOut(el,f) hapmapSnpsOutput(el,f,'\t','\n');
/* Print out hapmapSnps as a line in a tab-separated file. */

#define hapmapSnpsCommaOut(el,f) hapmapSnpsOutput(el,f,',',',');
/* Print out hapmapSnps as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */
/* items for trackUi options and filters */

#define HAP_POP_MIXED "hapmapSnps_isMixed"
#define HAP_POP_COUNT "hapmapSnps_popCount"
#define HAP_TYPE "hapmapSnps_polyType"
#define HAP_MIN_FREQ "hapmapSnps_minorAlleleFreqMinimum"
#define HAP_MAX_FREQ "hapmapSnps_minorAlleleFreqMaximum"
#define HAP_MIN_HET "hapmapSnps_hetMinimum"
#define HAP_MAX_OBSERVED_HET "hapmapSnps_obsHetMaximum"
#define HAP_MAX_EXPECTED_HET "hapmapSnps_expHetMaximum"
#define HAP_MONO_PREFIX "hapmapSnps_monomorphic"
#define HAP_ORTHO_PREFIX "hapmapSnps_ortho"
#define HAP_ORTHO_QUAL_PREFIX "hapmapSnps_orthoQual"

#define HAP_FILTER_DEFAULT "no filter"

#define HAP_MIN_FREQ_DEFAULT  "0.0"
#define HAP_MAX_FREQ_DEFAULT  "0.5"
#define HAP_MIN_HET_DEFAULT   "0.0"
#define HAP_MAX_EXPECTED_HET_DEFAULT   "0.5"
#define HAP_MAX_OBSERVED_HET_DEFAULT   "1.0"

#define HAP_ORTHO_QUAL_DEFAULT "0"

#define HAP_PHASEII_POPCOUNT 4
#define HAP_PHASEIII_POPCOUNT 11
#define HAP_ORTHO_COUNT 2

extern char *hapmapPhaseIIPops[HAP_PHASEII_POPCOUNT];
extern char *hapmapPhaseIIIPops[HAP_PHASEIII_POPCOUNT];

/* Someday this should come from a trackDb setting: */
extern char *hapmapOrthoSpecies[HAP_ORTHO_COUNT+1];

#endif /* HAPMAPSNPS_H */


