/* gtexSampleData.h was originally generated by the autoSql program, which also 
 * generated gtexSampleData.c and gtexSampleData.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef GTEXSAMPLEDATA_H
#define GTEXSAMPLEDATA_H

#define GTEXSAMPLEDATA_NUM_COLS 4

extern char *gtexSampleDataCommaSepFieldNames;

struct gtexSampleData
/* GTEX Expression data (RPKM levels, unmapped) */
    {
    struct gtexSampleData *next;  /* Next in singly linked list. */
    char *geneId;	/* Gene identifier (ensembl) */
    char *sample;	/* GTEX sample identifier */
    char *tissue;	/* Tissue short name */
    float score;	/* Expression level (RPKM) */
    };

void gtexSampleDataStaticLoad(char **row, struct gtexSampleData *ret);
/* Load a row from gtexSampleData table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct gtexSampleData *gtexSampleDataLoad(char **row);
/* Load a gtexSampleData from row fetched with select * from gtexSampleData
 * from database.  Dispose of this with gtexSampleDataFree(). */

struct gtexSampleData *gtexSampleDataLoadAll(char *fileName);
/* Load all gtexSampleData from whitespace-separated file.
 * Dispose of this with gtexSampleDataFreeList(). */

struct gtexSampleData *gtexSampleDataLoadAllByChar(char *fileName, char chopper);
/* Load all gtexSampleData from chopper separated file.
 * Dispose of this with gtexSampleDataFreeList(). */

#define gtexSampleDataLoadAllByTab(a) gtexSampleDataLoadAllByChar(a, '\t');
/* Load all gtexSampleData from tab separated file.
 * Dispose of this with gtexSampleDataFreeList(). */

struct gtexSampleData *gtexSampleDataCommaIn(char **pS, struct gtexSampleData *ret);
/* Create a gtexSampleData out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexSampleData */

void gtexSampleDataFree(struct gtexSampleData **pEl);
/* Free a single dynamically allocated gtexSampleData such as created
 * with gtexSampleDataLoad(). */

void gtexSampleDataFreeList(struct gtexSampleData **pList);
/* Free a list of dynamically allocated gtexSampleData's */

void gtexSampleDataOutput(struct gtexSampleData *el, FILE *f, char sep, char lastSep);
/* Print out gtexSampleData.  Separate fields with sep. Follow last field with lastSep. */

#define gtexSampleDataTabOut(el,f) gtexSampleDataOutput(el,f,'\t','\n');
/* Print out gtexSampleData as a line in a tab-separated file. */

#define gtexSampleDataCommaOut(el,f) gtexSampleDataOutput(el,f,',',',');
/* Print out gtexSampleData as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void gtexSampleDataCreateTable(struct sqlConnection *conn, char *table);
/* Create expression record format table of given name. */

#endif /* GTEXSAMPLEDATA_H */

