/* flyreg.h was originally generated by the autoSql program, which also 
 * generated flyreg.c and flyreg.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2004 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef FLYREG_H
#define FLYREG_H

#define FLYREG_NUM_COLS 6

struct flyreg
/* Flyreg data from Casey Bergman */
    {
    struct flyreg *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Factor */
    char *target;	/* Target */
    unsigned pmid;	/* PubMed ID */
    };

void flyregStaticLoad(char **row, struct flyreg *ret);
/* Load a row from flyreg table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct flyreg *flyregLoad(char **row);
/* Load a flyreg from row fetched with select * from flyreg
 * from database.  Dispose of this with flyregFree(). */

struct flyreg *flyregLoadAll(char *fileName);
/* Load all flyreg from whitespace-separated file.
 * Dispose of this with flyregFreeList(). */

struct flyreg *flyregLoadAllByChar(char *fileName, char chopper);
/* Load all flyreg from chopper separated file.
 * Dispose of this with flyregFreeList(). */

#define flyregLoadAllByTab(a) flyregLoadAllByChar(a, '\t');
/* Load all flyreg from tab separated file.
 * Dispose of this with flyregFreeList(). */

struct flyreg *flyregCommaIn(char **pS, struct flyreg *ret);
/* Create a flyreg out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new flyreg */

void flyregFree(struct flyreg **pEl);
/* Free a single dynamically allocated flyreg such as created
 * with flyregLoad(). */

void flyregFreeList(struct flyreg **pList);
/* Free a list of dynamically allocated flyreg's */

void flyregOutput(struct flyreg *el, FILE *f, char sep, char lastSep);
/* Print out flyreg.  Separate fields with sep. Follow last field with lastSep. */

#define flyregTabOut(el,f) flyregOutput(el,f,'\t','\n');
/* Print out flyreg as a line in a tab-separated file. */

#define flyregCommaOut(el,f) flyregOutput(el,f,',',',');
/* Print out flyreg as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* FLYREG_H */

