/* encodeErgeHssCellLines.h was originally generated by the autoSql program, which also 
 * generated encodeErgeHssCellLines.c and encodeErgeHssCellLines.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2008 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ENCODEERGEHSSCELLLINES_H
#define ENCODEERGEHSSCELLLINES_H

#define ENCODEERGEHSSCELLLINES_NUM_COLS 15

struct encodeErgeHssCellLines
/* ENCODE experimental data from dbERGEII */
    {
    struct encodeErgeHssCellLines *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of read - up to 255 characters */
    unsigned score;	/* Score from 0-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* Always zero for now */
    unsigned blockCount;	/* Number of separate blocks (regions without gaps) */
    unsigned *blockSizes;	/* Comma separated list of block sizes */
    unsigned *chromStarts;	/* Start position of each block in relative to chromStart */
    char *Id;	/* dbERGEII Id */
    char *color;	/* RGB color values */
    char *allLines;	/* List of all cell lines */
    };

struct encodeErgeHssCellLines *encodeErgeHssCellLinesLoad(char **row);
/* Load a encodeErgeHssCellLines from row fetched with select * from encodeErgeHssCellLines
 * from database.  Dispose of this with encodeErgeHssCellLinesFree(). */

struct encodeErgeHssCellLines *encodeErgeHssCellLinesLoadAll(char *fileName);
/* Load all encodeErgeHssCellLines from whitespace-separated file.
 * Dispose of this with encodeErgeHssCellLinesFreeList(). */

struct encodeErgeHssCellLines *encodeErgeHssCellLinesLoadAllByChar(char *fileName, char chopper);
/* Load all encodeErgeHssCellLines from chopper separated file.
 * Dispose of this with encodeErgeHssCellLinesFreeList(). */

#define encodeErgeHssCellLinesLoadAllByTab(a) encodeErgeHssCellLinesLoadAllByChar(a, '\t');
/* Load all encodeErgeHssCellLines from tab separated file.
 * Dispose of this with encodeErgeHssCellLinesFreeList(). */

struct encodeErgeHssCellLines *encodeErgeHssCellLinesCommaIn(char **pS, struct encodeErgeHssCellLines *ret);
/* Create a encodeErgeHssCellLines out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new encodeErgeHssCellLines */

void encodeErgeHssCellLinesFree(struct encodeErgeHssCellLines **pEl);
/* Free a single dynamically allocated encodeErgeHssCellLines such as created
 * with encodeErgeHssCellLinesLoad(). */

void encodeErgeHssCellLinesFreeList(struct encodeErgeHssCellLines **pList);
/* Free a list of dynamically allocated encodeErgeHssCellLines's */

void encodeErgeHssCellLinesOutput(struct encodeErgeHssCellLines *el, FILE *f, char sep, char lastSep);
/* Print out encodeErgeHssCellLines.  Separate fields with sep. Follow last field with lastSep. */

#define encodeErgeHssCellLinesTabOut(el,f) encodeErgeHssCellLinesOutput(el,f,'\t','\n');
/* Print out encodeErgeHssCellLines as a line in a tab-separated file. */

#define encodeErgeHssCellLinesCommaOut(el,f) encodeErgeHssCellLinesOutput(el,f,',',',');
/* Print out encodeErgeHssCellLines as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct encodeErgeHssCellLines *encodeErgeHssCellLinesLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all encodeErge from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with encodeErgeFreeList(). */


#endif /* ENCODEERGEHSSCELLLINES_H */

