/* dgvPlus.h was originally generated by the autoSql program, which also 
 * generated dgvPlus.c and dgvPlus.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef DGVPLUS_H
#define DGVPLUS_H

#define DGVPLUS_NUM_COLS 22

extern char *dgvPlusCommaSepFieldNames;

struct dgvPlus
/* Database of Genomic Variants incorporating dbVar, July 2013 and later */
    {
    struct dgvPlus *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* ID of merged variant or supporting variant */
    unsigned score;	/* Score from 0-1000 (placeholder for BED 9+ format) */
    char strand[2];	/* + or - (placeholder for BED 9+ format) */
    unsigned thickStart;	/* Same as chromStart (placeholder for BED 9+ format) */
    unsigned thickEnd;	/* Same as chromEnd (placeholder for BED 9+ format) */
    unsigned itemRgb;	/* Item R,G,B color. */
    char *varType;	/* Type of variation */
    char *reference;	/* Literature reference for the study that included this variant */
    unsigned pubMedId;	/* For linking to pubMed abstract of reference */
    char *method;	/* Brief description of method */
    char *platform;	/* Sequencing platform (if specified) */
    char *mergedVariants;	/* If this is a supporting variant, ID of merged variant */
    char *supportingVariants;	/* If this is a merged variant, IDs of supporting variants */
    unsigned sampleSize;	/* Number of samples in study */
    unsigned observedGains;	/* Number of samples with copy number gains */
    unsigned observedLosses;	/* Number of samples with copy number losses */
    char *cohortDescription;	/* Description of sample population for the study */
    char *genes;	/* Genes overlapping this variant */
    char *samples;	/* Sample IDs if available */
    };

void dgvPlusStaticLoad(char **row, struct dgvPlus *ret);
/* Load a row from dgvPlus table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct dgvPlus *dgvPlusLoad(char **row);
/* Load a dgvPlus from row fetched with select * from dgvPlus
 * from database.  Dispose of this with dgvPlusFree(). */

struct dgvPlus *dgvPlusLoadAll(char *fileName);
/* Load all dgvPlus from whitespace-separated file.
 * Dispose of this with dgvPlusFreeList(). */

struct dgvPlus *dgvPlusLoadAllByChar(char *fileName, char chopper);
/* Load all dgvPlus from chopper separated file.
 * Dispose of this with dgvPlusFreeList(). */

#define dgvPlusLoadAllByTab(a) dgvPlusLoadAllByChar(a, '\t');
/* Load all dgvPlus from tab separated file.
 * Dispose of this with dgvPlusFreeList(). */

struct dgvPlus *dgvPlusCommaIn(char **pS, struct dgvPlus *ret);
/* Create a dgvPlus out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dgvPlus */

void dgvPlusFree(struct dgvPlus **pEl);
/* Free a single dynamically allocated dgvPlus such as created
 * with dgvPlusLoad(). */

void dgvPlusFreeList(struct dgvPlus **pList);
/* Free a list of dynamically allocated dgvPlus's */

void dgvPlusOutput(struct dgvPlus *el, FILE *f, char sep, char lastSep);
/* Print out dgvPlus.  Separate fields with sep. Follow last field with lastSep. */

#define dgvPlusTabOut(el,f) dgvPlusOutput(el,f,'\t','\n');
/* Print out dgvPlus as a line in a tab-separated file. */

#define dgvPlusCommaOut(el,f) dgvPlusOutput(el,f,',',',');
/* Print out dgvPlus as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* DGVPLUS_H */

