/* dbSnpRs.h was originally generated by the autoSql program, which also 
 * generated dbSnpRs.c and dbSnpRs.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef DBSNPRS_H
#define DBSNPRS_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define DBSNPRS_NUM_COLS 9

struct dbSnpRs
/* Information from dbSNP at the reference SNP level */
    {
    struct dbSnpRs *next;  /* Next in singly linked list. */
    char *rsId;	/* dbSnp reference snp (rs) identifier */
    float avHet;	/* the average heterozygosity from all observations */
    float avHetSE;	/* the Standard Error for the average heterozygosity */
    char *valid;	/* the validation status of the SNP */
    char *allele1;	/* the sequence of the first allele */
    char *allele2;	/* the sequence of the second allele */
    char *assembly;	/* the sequence in the assembly */
    char *alternate;	/* the sequence of the alternate allele */
    char *func;	/* the functional category of the SNP, if any */
    };

void dbSnpRsStaticLoad(char **row, struct dbSnpRs *ret);
/* Load a row from dbSnpRs table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct dbSnpRs *dbSnpRsLoad(char **row);
/* Load a dbSnpRs from row fetched with select * from dbSnpRs
 * from database.  Dispose of this with dbSnpRsFree(). */

struct dbSnpRs *dbSnpRsLoadAll(char *fileName);
/* Load all dbSnpRs from whitespace-separated file.
 * Dispose of this with dbSnpRsFreeList(). */

struct dbSnpRs *dbSnpRsLoadAllByChar(char *fileName, char chopper);
/* Load all dbSnpRs from chopper separated file.
 * Dispose of this with dbSnpRsFreeList(). */

#define dbSnpRsLoadAllByTab(a) dbSnpRsLoadAllByChar(a, '\t');
/* Load all dbSnpRs from tab separated file.
 * Dispose of this with dbSnpRsFreeList(). */

struct dbSnpRs *dbSnpRsLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all dbSnpRs from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with dbSnpRsFreeList(). */

void dbSnpRsSaveToDb(struct sqlConnection *conn, struct dbSnpRs *el, char *tableName, int updateSize);
/* Save dbSnpRs as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct dbSnpRs *dbSnpRsCommaIn(char **pS, struct dbSnpRs *ret);
/* Create a dbSnpRs out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dbSnpRs */

void dbSnpRsFree(struct dbSnpRs **pEl);
/* Free a single dynamically allocated dbSnpRs such as created
 * with dbSnpRsLoad(). */

void dbSnpRsFreeList(struct dbSnpRs **pList);
/* Free a list of dynamically allocated dbSnpRs's */

void dbSnpRsOutput(struct dbSnpRs *el, FILE *f, char sep, char lastSep);
/* Print out dbSnpRs.  Separate fields with sep. Follow last field with lastSep. */

#define dbSnpRsTabOut(el,f) dbSnpRsOutput(el,f,'\t','\n');
/* Print out dbSnpRs as a line in a tab-separated file. */

#define dbSnpRsCommaOut(el,f) dbSnpRsOutput(el,f,',',',');
/* Print out dbSnpRs as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* DBSNPRS_H */

