/* chr18deletions.h was originally generated by the autoSql program, which also 
 * generated chr18deletions.c and chr18deletions.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2002 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef CHR18DELETIONS_H
#define CHR18DELETIONS_H

struct chr18deletions
/* Chromosome 18 deletion */
    {
    struct chr18deletions *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome or 'unknown' */
    int chromStart;	/* Start position in chrom - negative 1 if unpositioned */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* Name of STS marker */
    unsigned score;	/* Score of a marker = 1000/(# of placements) */
    char strand[2];	/* Strand = or - */
    unsigned ssCount;	/* Number of small blocks */
    unsigned *smallStarts;	/* Small start positions */
    unsigned seCount;	/* Number of small blocks */
    unsigned *smallEnds;	/* Small end positions */
    unsigned lsCount;	/* Number of large blocks */
    unsigned *largeStarts;	/* Large start positions */
    unsigned leCount;	/* Number of large blocks */
    unsigned *largeEnds;	/* Large end positions */
    };

struct chr18deletions *chr18deletionsLoad(char **row);
/* Load a chr18deletions from row fetched with select * from chr18deletions
 * from database.  Dispose of this with chr18deletionsFree(). */

struct chr18deletions *chr18deletionsLoadAll(char *fileName);
/* Load all chr18deletions from a tab-separated file.
 * Dispose of this with chr18deletionsFreeList(). */

struct chr18deletions *chr18deletionsLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all chr18deletions from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with chr18deletionsFreeList(). */

struct chr18deletions *chr18deletionsCommaIn(char **pS, struct chr18deletions *ret);
/* Create a chr18deletions out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new chr18deletions */

void chr18deletionsFree(struct chr18deletions **pEl);
/* Free a single dynamically allocated chr18deletions such as created
 * with chr18deletionsLoad(). */

void chr18deletionsFreeList(struct chr18deletions **pList);
/* Free a list of dynamically allocated chr18deletions's */

void chr18deletionsOutput(struct chr18deletions *el, FILE *f, char sep, char lastSep);
/* Print out chr18deletions.  Separate fields with sep. Follow last field with lastSep. */

#define chr18deletionsTabOut(el,f) chr18deletionsOutput(el,f,'\t','\n');
/* Print out chr18deletions as a line in a tab-separated file. */

#define chr18deletionsCommaOut(el,f) chr18deletionsOutput(el,f,',',',');
/* Print out chr18deletions as a comma separated list including final comma. */

#endif /* CHR18DELETIONS_H */

