/* bigGenePred.h was originally generated by the autoSql program, which also 
 * generated bigGenePred.c and bigGenePred.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BIGGENEPRED_H
#define BIGGENEPRED_H

#define BIGGENEPRED_NUM_COLS 20

#include "genePred.h"
#include "asParse.h"

extern char *bigGenePredCommaSepFieldNames;

struct bigGenePred
/* bigGenePred gene models */
    {
    struct bigGenePred *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name or ID of item, ideally both human readable and unique */
    unsigned score;	/* Score (0-1000) */
    char strand[2];	/* + or - for strand */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned itemRgb;	/* RGB value (use R,G,B string in input file) */
    unsigned blockCount;	/* Number of blocks */
    unsigned *blockSizes;	/* Comma separated list of block sizes */
    unsigned *chromStarts;	/* Start positions relative to chromStart */
    char *name2;	/* Alternative/human readable name */
    enum cdsStatus  cdsStartStat;	/* enum('none','unk','incmpl','cmpl') */
    enum cdsStatus cdsEndStat;	/* enum('none','unk','incmpl','cmpl') */
    int *exonFrames;	/* Reading frame of the start of the CDS region of the exon,
                         * in the direction of transcription (0,1,2), or -1 if there
                         * is no CDS region. */
    char *type;	/* Transcript type */
    char *geneName;	/* Primary identifier for gene */
    char *geneName2;	/* Alternative/human readable gene name */
    char *geneType;	/* Gene type */
    };

struct bigGenePred *bigGenePredLoad(char **row);
/* Load a bigGenePred from row fetched with select * from bigGenePred
 * from database.  Dispose of this with bigGenePredFree(). */

struct bigGenePred *bigGenePredLoadAll(char *fileName);
/* Load all bigGenePred from whitespace-separated file.
 * Dispose of this with bigGenePredFreeList(). */

struct bigGenePred *bigGenePredLoadAllByChar(char *fileName, char chopper);
/* Load all bigGenePred from chopper separated file.
 * Dispose of this with bigGenePredFreeList(). */

#define bigGenePredLoadAllByTab(a) bigGenePredLoadAllByChar(a, '\t');
/* Load all bigGenePred from tab separated file.
 * Dispose of this with bigGenePredFreeList(). */

struct bigGenePred *bigGenePredCommaIn(char **pS, struct bigGenePred *ret);
/* Create a bigGenePred out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bigGenePred */

void bigGenePredFree(struct bigGenePred **pEl);
/* Free a single dynamically allocated bigGenePred such as created
 * with bigGenePredLoad(). */

void bigGenePredFreeList(struct bigGenePred **pList);
/* Free a list of dynamically allocated bigGenePred's */

void bigGenePredOutput(struct bigGenePred *el, FILE *f, char sep, char lastSep);
/* Print out bigGenePred.  Separate fields with sep. Follow last field with lastSep. */

#define bigGenePredTabOut(el,f) bigGenePredOutput(el,f,'\t','\n');
/* Print out bigGenePred as a line in a tab-separated file. */

#define bigGenePredCommaOut(el,f) bigGenePredOutput(el,f,',',',');
/* Print out bigGenePred as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct asObject *bigGenePredAsObj();
// Return asObject describing fields of bigGenePred

#endif /* BIGGENEPRED_H */
