/* bedLogR.h was originally generated by the autoSql program, which also 
 * generated bedLogR.c and bedLogR.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2011 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef BEDLOGR_H
#define BEDLOGR_H

#define BEDLOGR_NUM_COLS 10

struct bedLogR
/* BED9 +  floating point score */
    {
    struct bedLogR *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome (or contig, scaffold, etc.) */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* Score from 0-1000 */
    char strand[2];	/* + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* Used as itemRgb as of 2004-11-22 */
    float logR;	/* logR value */
    };

void bedLogRStaticLoad(char **row, struct bedLogR *ret);
/* Load a row from bedLogR table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bedLogR *bedLogRLoad(char **row);
/* Load a bedLogR from row fetched with select * from bedLogR
 * from database.  Dispose of this with bedLogRFree(). */

struct bedLogR *bedLogRLoadAll(char *fileName);
/* Load all bedLogR from whitespace-separated file.
 * Dispose of this with bedLogRFreeList(). */

struct bedLogR *bedLogRLoadAllByChar(char *fileName, char chopper);
/* Load all bedLogR from chopper separated file.
 * Dispose of this with bedLogRFreeList(). */

#define bedLogRLoadAllByTab(a) bedLogRLoadAllByChar(a, '\t');
/* Load all bedLogR from tab separated file.
 * Dispose of this with bedLogRFreeList(). */

struct bedLogR *bedLogRCommaIn(char **pS, struct bedLogR *ret);
/* Create a bedLogR out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bedLogR */

void bedLogRFree(struct bedLogR **pEl);
/* Free a single dynamically allocated bedLogR such as created
 * with bedLogRLoad(). */

void bedLogRFreeList(struct bedLogR **pList);
/* Free a list of dynamically allocated bedLogR's */

void bedLogROutput(struct bedLogR *el, FILE *f, char sep, char lastSep);
/* Print out bedLogR.  Separate fields with sep. Follow last field with lastSep. */

#define bedLogRTabOut(el,f) bedLogROutput(el,f,'\t','\n');
/* Print out bedLogR as a line in a tab-separated file. */

#define bedLogRCommaOut(el,f) bedLogROutput(el,f,',',',');
/* Print out bedLogR as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BEDLOGR_H */

