/* Parser to read in a cdwBamFile from a ra file where tags in ra file correspond to fields in a
 * struct. This program was generated by raToStructGen. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "hash.h"
#include "obscure.h"
#include "sqlNum.h"
#include "sqlList.h"
#include "ra.h"
#include "raToStruct.h"
#include "cdw.h"

struct raToStructReader *cdwBamFileRaReader()
/* Make a raToStructReader for cdwBamFile */
{
static char *fields[] = {
    "isPaired",
    "isSortedByTarget",
    "readCount",
    "readBaseCount",
    "mappedCount",
    "uniqueMappedCount",
    "readSizeMean",
    "readSizeStd",
    "readSizeMin",
    "readSizeMax",
    "u4mReadCount",
    "u4mUniquePos",
    "u4mUniqueRatio",
    "targetBaseCount",
    "targetSeqCount",
    };
static char *requiredFields[] = {
    "isPaired",
    "isSortedByTarget",
    "readCount",
    "readBaseCount",
    "mappedCount",
    "uniqueMappedCount",
    "readSizeMean",
    "readSizeStd",
    "readSizeMin",
    "readSizeMax",
    "u4mReadCount",
    "u4mUniquePos",
    "u4mUniqueRatio",
    "targetBaseCount",
    "targetSeqCount",
    };
return raToStructReaderNew("cdwBamFile", ArraySize(fields), fields, ArraySize(requiredFields), requiredFields);
}


struct cdwBamFile *cdwBamFileFromNextRa(struct lineFile *lf, struct raToStructReader *reader)
/* Return next stanza put into an cdwBamFile. */
{
enum fields
    {
    isPairedField,
    isSortedByTargetField,
    readCountField,
    readBaseCountField,
    mappedCountField,
    uniqueMappedCountField,
    readSizeMeanField,
    readSizeStdField,
    readSizeMinField,
    readSizeMaxField,
    u4mReadCountField,
    u4mUniquePosField,
    u4mUniqueRatioField,
    targetBaseCountField,
    targetSeqCountField,
    };
if (!raSkipLeadingEmptyLines(lf, NULL))
    return NULL;

struct cdwBamFile *el;
AllocVar(el);

bool *fieldsObserved = reader->fieldsObserved;
bzero(fieldsObserved, reader->fieldCount);

char *tag, *val;
while (raNextTagVal(lf, &tag, &val, NULL))
    {
    struct hashEl *hel = hashLookup(reader->fieldIds, tag);
    if (hel != NULL)
        {
	int id = ptToInt(hel->val);
	if (fieldsObserved[id])
	     errAbort("Duplicate tag %s line %d of %s\n", tag, lf->lineIx, lf->fileName);
	fieldsObserved[id] = TRUE;
	switch (id)
	    {
	    case isPairedField:
	        {
	        el->isPaired = sqlSigned(val);
		break;
	        }
	    case isSortedByTargetField:
	        {
	        el->isSortedByTarget = sqlSigned(val);
		break;
	        }
	    case readCountField:
	        {
	        el->readCount = sqlLongLong(val);
		break;
	        }
	    case readBaseCountField:
	        {
	        el->readBaseCount = sqlLongLong(val);
		break;
	        }
	    case mappedCountField:
	        {
	        el->mappedCount = sqlLongLong(val);
		break;
	        }
	    case uniqueMappedCountField:
	        {
	        el->uniqueMappedCount = sqlLongLong(val);
		break;
	        }
	    case readSizeMeanField:
	        {
	        el->readSizeMean = sqlDouble(val);
		break;
	        }
	    case readSizeStdField:
	        {
	        el->readSizeStd = sqlDouble(val);
		break;
	        }
	    case readSizeMinField:
	        {
	        el->readSizeMin = sqlSigned(val);
		break;
	        }
	    case readSizeMaxField:
	        {
	        el->readSizeMax = sqlSigned(val);
		break;
	        }
	    case u4mReadCountField:
	        {
	        el->u4mReadCount = sqlSigned(val);
		break;
	        }
	    case u4mUniquePosField:
	        {
	        el->u4mUniquePos = sqlSigned(val);
		break;
	        }
	    case u4mUniqueRatioField:
	        {
	        el->u4mUniqueRatio = sqlDouble(val);
		break;
	        }
	    case targetBaseCountField:
	        {
	        el->targetBaseCount = sqlLongLong(val);
		break;
	        }
	    case targetSeqCountField:
	        {
	        el->targetSeqCount = sqlUnsigned(val);
		break;
	        }
	    default:
	        internalErr();
		break;
	    }
	}
    }

raToStructReaderCheckRequiredFields(reader, lf);
return el;
}

struct cdwBamFile *cdwBamFileLoadRa(char *fileName)
/* Return list of all cdwBamFile in ra file. */
{
struct raToStructReader *reader = cdwBamFileRaReader();
struct lineFile *lf = lineFileOpen(fileName, TRUE);
struct cdwBamFile *el, *list = NULL;
while ((el = cdwBamFileFromNextRa(lf, reader)) != NULL)
    slAddHead(&list, el);
slReverse(&list);
lineFileClose(&lf);
raToStructReaderFree(&reader);
return list;
}

struct cdwBamFile *cdwBamFileOneFromRa(char *fileName)
/* Return cdwBamFile in file and insist there be exactly one record. */
{
struct cdwBamFile *one = cdwBamFileLoadRa(fileName);
if (one == NULL)
    errAbort("No data in %s", fileName);
if (one->next != NULL)
    errAbort("Multiple records in %s", fileName);
return one;
}

