/* sgdDescription.c was originally generated by the autoSql program, which also 
 * generated sgdDescription.h and sgdDescription.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "sgdDescription.h"


void sgdDescriptionStaticLoad(char **row, struct sgdDescription *ret)
/* Load a row from sgdDescription table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->type = row[1];
ret->description = row[2];
}

struct sgdDescription *sgdDescriptionLoad(char **row)
/* Load a sgdDescription from row fetched with select * from sgdDescription
 * from database.  Dispose of this with sgdDescriptionFree(). */
{
struct sgdDescription *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->type = cloneString(row[1]);
ret->description = cloneString(row[2]);
return ret;
}

struct sgdDescription *sgdDescriptionLoadAll(char *fileName) 
/* Load all sgdDescription from a whitespace-separated file.
 * Dispose of this with sgdDescriptionFreeList(). */
{
struct sgdDescription *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = sgdDescriptionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sgdDescription *sgdDescriptionLoadAllByChar(char *fileName, char chopper) 
/* Load all sgdDescription from a chopper separated file.
 * Dispose of this with sgdDescriptionFreeList(). */
{
struct sgdDescription *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = sgdDescriptionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sgdDescription *sgdDescriptionCommaIn(char **pS, struct sgdDescription *ret)
/* Create a sgdDescription out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sgdDescription */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->type = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void sgdDescriptionFree(struct sgdDescription **pEl)
/* Free a single dynamically allocated sgdDescription such as created
 * with sgdDescriptionLoad(). */
{
struct sgdDescription *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->type);
freeMem(el->description);
freez(pEl);
}

void sgdDescriptionFreeList(struct sgdDescription **pList)
/* Free a list of dynamically allocated sgdDescription's */
{
struct sgdDescription *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    sgdDescriptionFree(&el);
    }
*pList = NULL;
}

void sgdDescriptionOutput(struct sgdDescription *el, FILE *f, char sep, char lastSep) 
/* Print out sgdDescription.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

