/* oreganno.c was originally generated by the autoSql program, which also 
 * generated oreganno.h and oreganno.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "oreganno.h"


void oregannoStaticLoad(char **row, struct oreganno *ret)
/* Load a row from oreganno table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->bin = sqlUnsigned(row[0]);
ret->chrom = row[1];
ret->chromStart = sqlUnsigned(row[2]);
ret->chromEnd = sqlUnsigned(row[3]);
ret->id = row[4];
strcpy(ret->strand, row[5]);
ret->name = row[6];
}

struct oreganno *oregannoLoad(char **row)
/* Load a oreganno from row fetched with select * from oreganno
 * from database.  Dispose of this with oregannoFree(). */
{
struct oreganno *ret;

AllocVar(ret);
ret->bin = sqlUnsigned(row[0]);
ret->chrom = cloneString(row[1]);
ret->chromStart = sqlUnsigned(row[2]);
ret->chromEnd = sqlUnsigned(row[3]);
ret->id = cloneString(row[4]);
strcpy(ret->strand, row[5]);
ret->name = cloneString(row[6]);
return ret;
}

struct oreganno *oregannoLoadAll(char *fileName) 
/* Load all oreganno from a whitespace-separated file.
 * Dispose of this with oregannoFreeList(). */
{
struct oreganno *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = oregannoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct oreganno *oregannoLoadAllByChar(char *fileName, char chopper) 
/* Load all oreganno from a chopper separated file.
 * Dispose of this with oregannoFreeList(). */
{
struct oreganno *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = oregannoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct oreganno *oregannoLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all oreganno from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with oregannoFreeList(). */
{
struct oreganno *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = oregannoLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void oregannoSaveToDb(struct sqlConnection *conn, struct oreganno *el, char *tableName, int updateSize)
/* Save oreganno as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%u,%u,'%s','%s','%s')", 
	tableName,  el->bin,  el->chrom,  el->chromStart,  el->chromEnd,  el->id,  el->strand,  el->name);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}


struct oreganno *oregannoCommaIn(char **pS, struct oreganno *ret)
/* Create a oreganno out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new oreganno */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->bin = sqlUnsignedComma(&s);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->id = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void oregannoFree(struct oreganno **pEl)
/* Free a single dynamically allocated oreganno such as created
 * with oregannoLoad(). */
{
struct oreganno *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->id);
freeMem(el->name);
freez(pEl);
}

void oregannoFreeList(struct oreganno **pList)
/* Free a list of dynamically allocated oreganno's */
{
struct oreganno *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    oregannoFree(&el);
    }
*pList = NULL;
}

void oregannoOutput(struct oreganno *el, FILE *f, char sep, char lastSep) 
/* Print out oreganno.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->bin);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->id);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void oregannoAttrStaticLoad(char **row, struct oregannoAttr *ret)
/* Load a row from oregannoAttr table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = row[0];
ret->attribute = row[1];
ret->attrVal = row[2];
}

struct oregannoAttr *oregannoAttrLoad(char **row)
/* Load a oregannoAttr from row fetched with select * from oregannoAttr
 * from database.  Dispose of this with oregannoAttrFree(). */
{
struct oregannoAttr *ret;

AllocVar(ret);
ret->id = cloneString(row[0]);
ret->attribute = cloneString(row[1]);
ret->attrVal = cloneString(row[2]);
return ret;
}

struct oregannoAttr *oregannoAttrLoadAll(char *fileName) 
/* Load all oregannoAttr from a whitespace-separated file.
 * Dispose of this with oregannoAttrFreeList(). */
{
struct oregannoAttr *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = oregannoAttrLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct oregannoAttr *oregannoAttrLoadAllByChar(char *fileName, char chopper) 
/* Load all oregannoAttr from a chopper separated file.
 * Dispose of this with oregannoAttrFreeList(). */
{
struct oregannoAttr *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = oregannoAttrLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct oregannoAttr *oregannoAttrLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all oregannoAttr from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with oregannoAttrFreeList(). */
{
struct oregannoAttr *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = oregannoAttrLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void oregannoAttrSaveToDb(struct sqlConnection *conn, struct oregannoAttr *el, char *tableName, int updateSize)
/* Save oregannoAttr as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s','%s')", 
	tableName,  el->id,  el->attribute,  el->attrVal);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}


struct oregannoAttr *oregannoAttrCommaIn(char **pS, struct oregannoAttr *ret)
/* Create a oregannoAttr out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new oregannoAttr */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlStringComma(&s);
ret->attribute = sqlStringComma(&s);
ret->attrVal = sqlStringComma(&s);
*pS = s;
return ret;
}

void oregannoAttrFree(struct oregannoAttr **pEl)
/* Free a single dynamically allocated oregannoAttr such as created
 * with oregannoAttrLoad(). */
{
struct oregannoAttr *el;

if ((el = *pEl) == NULL) return;
freeMem(el->id);
freeMem(el->attribute);
freeMem(el->attrVal);
freez(pEl);
}

void oregannoAttrFreeList(struct oregannoAttr **pList)
/* Free a list of dynamically allocated oregannoAttr's */
{
struct oregannoAttr *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    oregannoAttrFree(&el);
    }
*pList = NULL;
}

void oregannoAttrOutput(struct oregannoAttr *el, FILE *f, char sep, char lastSep) 
/* Print out oregannoAttr.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->id);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->attribute);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->attrVal);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void oregannoLinkStaticLoad(char **row, struct oregannoLink *ret)
/* Load a row from oregannoLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = row[0];
ret->attribute = row[1];
ret->raKey = row[2];
ret->attrAcc = row[3];
}

struct oregannoLink *oregannoLinkLoad(char **row)
/* Load a oregannoLink from row fetched with select * from oregannoLink
 * from database.  Dispose of this with oregannoLinkFree(). */
{
struct oregannoLink *ret;

AllocVar(ret);
ret->id = cloneString(row[0]);
ret->attribute = cloneString(row[1]);
ret->raKey = cloneString(row[2]);
ret->attrAcc = cloneString(row[3]);
return ret;
}

struct oregannoLink *oregannoLinkLoadAll(char *fileName) 
/* Load all oregannoLink from a whitespace-separated file.
 * Dispose of this with oregannoLinkFreeList(). */
{
struct oregannoLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = oregannoLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct oregannoLink *oregannoLinkLoadAllByChar(char *fileName, char chopper) 
/* Load all oregannoLink from a chopper separated file.
 * Dispose of this with oregannoLinkFreeList(). */
{
struct oregannoLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = oregannoLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct oregannoLink *oregannoLinkLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all oregannoLink from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with oregannoLinkFreeList(). */
{
struct oregannoLink *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = oregannoLinkLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void oregannoLinkSaveToDb(struct sqlConnection *conn, struct oregannoLink *el, char *tableName, int updateSize)
/* Save oregannoLink as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s','%s','%s')", 
	tableName,  el->id,  el->attribute,  el->raKey,  el->attrAcc);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}


struct oregannoLink *oregannoLinkCommaIn(char **pS, struct oregannoLink *ret)
/* Create a oregannoLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new oregannoLink */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlStringComma(&s);
ret->attribute = sqlStringComma(&s);
ret->raKey = sqlStringComma(&s);
ret->attrAcc = sqlStringComma(&s);
*pS = s;
return ret;
}

void oregannoLinkFree(struct oregannoLink **pEl)
/* Free a single dynamically allocated oregannoLink such as created
 * with oregannoLinkLoad(). */
{
struct oregannoLink *el;

if ((el = *pEl) == NULL) return;
freeMem(el->id);
freeMem(el->attribute);
freeMem(el->raKey);
freeMem(el->attrAcc);
freez(pEl);
}

void oregannoLinkFreeList(struct oregannoLink **pList)
/* Free a list of dynamically allocated oregannoLink's */
{
struct oregannoLink *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    oregannoLinkFree(&el);
    }
*pList = NULL;
}

void oregannoLinkOutput(struct oregannoLink *el, FILE *f, char sep, char lastSep) 
/* Print out oregannoLink.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->id);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->attribute);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->raKey);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->attrAcc);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct hash *oregannoLoadAttrHash(struct sqlConnection *conn)
/* Construct a hash table of the entries in the oregannoAttr table, indexed by ID.
 * Free with hashFreeWithVals(&attrHash, oregannoAttrFree).
 */
{
struct hash *attrHash = hashNew(0);
struct sqlResult *result = NULL;
struct oregannoAttr *attr = NULL;
char query[2048], **row = NULL;

sqlSafef(query, sizeof(query), "select * from oregannoAttr where attribute = 'type'");
result = sqlGetResult (conn, query);
while ((row = sqlNextRow(result)) != NULL)
    {
    attr = oregannoAttrLoad(row);
    hashAdd (attrHash, attr->id, attr);
    }
sqlFreeResult(&result);
return attrHash;
}
