/* mainTest.c was originally generated by the autoSql program, which also 
 * generated mainTest.h and mainTest.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "output/mainTest.h"



char *ptCommaSepFieldNames = "x,y";

struct pt *ptLoad(char **row)
/* Load a pt from row fetched with select * from pt
 * from database.  Dispose of this with ptFree(). */
{
struct pt *ret;

AllocVar(ret);
ret->x = sqlSigned(row[0]);
ret->y = sqlSigned(row[1]);
return ret;
}

struct pt *ptLoadAll(char *fileName) 
/* Load all pt from a whitespace-separated file.
 * Dispose of this with ptFreeList(). */
{
struct pt *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = ptLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct pt *ptLoadAllByChar(char *fileName, char chopper) 
/* Load all pt from a chopper separated file.
 * Dispose of this with ptFreeList(). */
{
struct pt *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = ptLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct pt *ptCommaIn(char **pS, struct pt *ret)
/* Create a pt out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new pt */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->x = sqlSignedComma(&s);
ret->y = sqlSignedComma(&s);
*pS = s;
return ret;
}

void ptOutput(struct pt *el, FILE *f, char sep, char lastSep) 
/* Print out pt.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->x);
fputc(sep,f);
fprintf(f, "%d", el->y);
fputc(lastSep,f);
}


char *pointCommaSepFieldNames = "acc,x,y,z,pt";

struct point *pointLoad(char **row)
/* Load a point from row fetched with select * from point
 * from database.  Dispose of this with pointFree(). */
{
struct point *ret;

AllocVar(ret);
safecpy(ret->acc, sizeof(ret->acc), row[0]);
ret->x = sqlSigned(row[1]);
ret->y = sqlSigned(row[2]);
ret->z = sqlSigned(row[3]);
{
char *s = row[4];
if(s != NULL && differentString(s, ""))
   ptCommaIn(&s, &ret->pt);
}
return ret;
}

struct point *pointLoadAll(char *fileName) 
/* Load all point from a whitespace-separated file.
 * Dispose of this with pointFreeList(). */
{
struct point *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = pointLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct point *pointLoadAllByChar(char *fileName, char chopper) 
/* Load all point from a chopper separated file.
 * Dispose of this with pointFreeList(). */
{
struct point *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = pointLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct point *pointCommaIn(char **pS, struct point *ret)
/* Create a point out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new point */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->acc, sizeof(ret->acc));
ret->x = sqlSignedComma(&s);
ret->y = sqlSignedComma(&s);
ret->z = sqlSignedComma(&s);
s = sqlEatChar(s, '{');
if(s[0] != '}')    ptCommaIn(&s, &ret->pt);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
*pS = s;
return ret;
}

void pointFree(struct point **pEl)
/* Free a single dynamically allocated point such as created
 * with pointLoad(). */
{
struct point *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void pointFreeList(struct point **pList)
/* Free a list of dynamically allocated point's */
{
struct point *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    pointFree(&el);
    }
*pList = NULL;
}

void pointOutput(struct point *el, FILE *f, char sep, char lastSep) 
/* Print out point.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->x);
fputc(sep,f);
fprintf(f, "%d", el->y);
fputc(sep,f);
fprintf(f, "%d", el->z);
fputc(sep,f);
if (sep == ',') fputc('{',f);
ptCommaOut(&el->pt,f);
if (sep == ',') fputc('}',f);
fputc(lastSep,f);
}


char *polygonCommaSepFieldNames = "id,pointCount,points,persp";

struct polygon *polygonLoad(char **row)
/* Load a polygon from row fetched with select * from polygon
 * from database.  Dispose of this with polygonFree(). */
{
struct polygon *ret;

AllocVar(ret);
ret->pointCount = sqlSigned(row[1]);
ret->id = sqlUnsigned(row[0]);
{
int i;
char *s = row[2];
for (i=0; i<ret->pointCount; ++i)
    {
    s = sqlEatChar(s, '{');
    slSafeAddHead(&ret->points, pointCommaIn(&s, NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->points);
}
{
int i;
char *s = row[3];
AllocArray(ret->persp, ret->pointCount);
for (i=0; i<ret->pointCount; ++i)
    {
    s = sqlEatChar(s, '{');
    ptCommaIn(&s, &ret->persp[i]);
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
}
return ret;
}

struct polygon *polygonLoadAll(char *fileName) 
/* Load all polygon from a whitespace-separated file.
 * Dispose of this with polygonFreeList(). */
{
struct polygon *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = polygonLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct polygon *polygonLoadAllByChar(char *fileName, char chopper) 
/* Load all polygon from a chopper separated file.
 * Dispose of this with polygonFreeList(). */
{
struct polygon *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = polygonLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct polygon *polygonCommaIn(char **pS, struct polygon *ret)
/* Create a polygon out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new polygon */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->pointCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<ret->pointCount; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        slSafeAddHead(&ret->points, pointCommaIn(&s,NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->points);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->persp, ret->pointCount);
for (i=0; i<ret->pointCount; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        ptCommaIn(&s, &ret->persp[i]);
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void polygonFree(struct polygon **pEl)
/* Free a single dynamically allocated polygon such as created
 * with polygonLoad(). */
{
struct polygon *el;

if ((el = *pEl) == NULL) return;
pointFreeList(&el->points);
freeMem(el->persp);
freez(pEl);
}

void polygonFreeList(struct polygon **pList)
/* Free a list of dynamically allocated polygon's */
{
struct polygon *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    polygonFree(&el);
    }
*pList = NULL;
}

void polygonOutput(struct polygon *el, FILE *f, char sep, char lastSep) 
/* Print out polygon.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%d", el->pointCount);
fputc(sep,f);
{
int i;
/* Loading point list. */
    {
    struct point *it = el->points;
    if (sep == ',') fputc('{',f);
    for (i=0; i<el->pointCount; ++i)
        {
        fputc('{',f);
        pointCommaOut(it,f);
        it = it->next;
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(sep,f);
{
int i;
/* Loading pt list. */
    {
    struct pt *it = el->persp;
    if (sep == ',') fputc('{',f);
    for (i=0; i<el->pointCount; ++i)
        {
        fputc('{',f);
        ptCommaOut(&it[i],f);
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(lastSep,f);
}


char *polyhedronCommaSepFieldNames = "id,names,polygonCount,polygons,screenBox";

struct polyhedron *polyhedronLoad(char **row)
/* Load a polyhedron from row fetched with select * from polyhedron
 * from database.  Dispose of this with polyhedronFree(). */
{
struct polyhedron *ret;

AllocVar(ret);
ret->polygonCount = sqlSigned(row[2]);
ret->id = sqlUnsigned(row[0]);
{
char *s = cloneString(row[1]);
sqlStringArray(s, ret->names, 2);
}
{
int i;
char *s = row[3];
for (i=0; i<ret->polygonCount; ++i)
    {
    s = sqlEatChar(s, '{');
    slSafeAddHead(&ret->polygons, polygonCommaIn(&s, NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->polygons);
}
{
int i;
char *s = row[4];
for (i=0; i<2; ++i)
    {
    s = sqlEatChar(s, '{');
    ptCommaIn(&s, &ret->screenBox[i]);
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
}
return ret;
}

struct polyhedron *polyhedronLoadAll(char *fileName) 
/* Load all polyhedron from a whitespace-separated file.
 * Dispose of this with polyhedronFreeList(). */
{
struct polyhedron *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = polyhedronLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct polyhedron *polyhedronLoadAllByChar(char *fileName, char chopper) 
/* Load all polyhedron from a chopper separated file.
 * Dispose of this with polyhedronFreeList(). */
{
struct polyhedron *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = polyhedronLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct polyhedron *polyhedronCommaIn(char **pS, struct polyhedron *ret)
/* Create a polyhedron out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new polyhedron */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<2; ++i)
    {
    ret->names[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->polygonCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<ret->polygonCount; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        slSafeAddHead(&ret->polygons, polygonCommaIn(&s,NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->polygons);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<2; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        ptCommaIn(&s, &ret->screenBox[i]);
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void polyhedronFree(struct polyhedron **pEl)
/* Free a single dynamically allocated polyhedron such as created
 * with polyhedronLoad(). */
{
struct polyhedron *el;

if ((el = *pEl) == NULL) return;
/* All strings in names are allocated at once, so only need to free first. */
if (el->names != NULL)
    freeMem(el->names[0]);
polygonFreeList(&el->polygons);
freez(pEl);
}

void polyhedronFreeList(struct polyhedron **pList)
/* Free a list of dynamically allocated polyhedron's */
{
struct polyhedron *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    polyhedronFree(&el);
    }
*pList = NULL;
}

void polyhedronOutput(struct polyhedron *el, FILE *f, char sep, char lastSep) 
/* Print out polyhedron.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<2; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->names[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
fprintf(f, "%d", el->polygonCount);
fputc(sep,f);
{
int i;
/* Loading polygon list. */
    {
    struct polygon *it = el->polygons;
    if (sep == ',') fputc('{',f);
    for (i=0; i<el->polygonCount; ++i)
        {
        fputc('{',f);
        polygonCommaOut(it,f);
        it = it->next;
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(sep,f);
{
int i;
/* Loading pt list. */
    {
    struct pt *it = el->screenBox;
    if (sep == ',') fputc('{',f);
    for (i=0; i<2; ++i)
        {
        fputc('{',f);
        ptCommaOut(&it[i],f);
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(lastSep,f);
}


char *twoPointCommaSepFieldNames = "name,a,b,points";

struct twoPoint *twoPointLoad(char **row)
/* Load a twoPoint from row fetched with select * from twoPoint
 * from database.  Dispose of this with twoPointFree(). */
{
struct twoPoint *ret;

AllocVar(ret);
safecpy(ret->name, sizeof(ret->name), row[0]);
{
char *s = row[1];
if(s != NULL && differentString(s, ""))
   ptCommaIn(&s, &ret->a);
}
{
char *s = row[2];
if(s != NULL && differentString(s, ""))
   ptCommaIn(&s, &ret->b);
}
{
int i;
char *s = row[3];
for (i=0; i<2; ++i)
    {
    s = sqlEatChar(s, '{');
    ptCommaIn(&s, &ret->points[i]);
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
}
return ret;
}

struct twoPoint *twoPointLoadAll(char *fileName) 
/* Load all twoPoint from a whitespace-separated file.
 * Dispose of this with twoPointFreeList(). */
{
struct twoPoint *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = twoPointLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct twoPoint *twoPointLoadAllByChar(char *fileName, char chopper) 
/* Load all twoPoint from a chopper separated file.
 * Dispose of this with twoPointFreeList(). */
{
struct twoPoint *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = twoPointLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct twoPoint *twoPointCommaIn(char **pS, struct twoPoint *ret)
/* Create a twoPoint out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new twoPoint */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->name, sizeof(ret->name));
s = sqlEatChar(s, '{');
if(s[0] != '}')    ptCommaIn(&s, &ret->a);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
s = sqlEatChar(s, '{');
if(s[0] != '}')    ptCommaIn(&s, &ret->b);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<2; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        ptCommaIn(&s, &ret->points[i]);
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void twoPointOutput(struct twoPoint *el, FILE *f, char sep, char lastSep) 
/* Print out twoPoint.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('{',f);
ptCommaOut(&el->a,f);
if (sep == ',') fputc('}',f);
fputc(sep,f);
if (sep == ',') fputc('{',f);
ptCommaOut(&el->b,f);
if (sep == ',') fputc('}',f);
fputc(sep,f);
{
int i;
/* Loading pt list. */
    {
    struct pt *it = el->points;
    if (sep == ',') fputc('{',f);
    for (i=0; i<2; ++i)
        {
        fputc('{',f);
        ptCommaOut(&it[i],f);
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(lastSep,f);
}


char *stringArrayCommaSepFieldNames = "numNames,names";

struct stringArray *stringArrayLoad(char **row)
/* Load a stringArray from row fetched with select * from stringArray
 * from database.  Dispose of this with stringArrayFree(). */
{
struct stringArray *ret;

AllocVar(ret);
ret->numNames = sqlSigned(row[0]);
{
int sizeOne;
sqlStringDynamicArray(row[1], &ret->names, &sizeOne);
assert(sizeOne == ret->numNames);
}
return ret;
}

struct stringArray *stringArrayLoadAll(char *fileName) 
/* Load all stringArray from a whitespace-separated file.
 * Dispose of this with stringArrayFreeList(). */
{
struct stringArray *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = stringArrayLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct stringArray *stringArrayLoadAllByChar(char *fileName, char chopper) 
/* Load all stringArray from a chopper separated file.
 * Dispose of this with stringArrayFreeList(). */
{
struct stringArray *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = stringArrayLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct stringArray *stringArrayCommaIn(char **pS, struct stringArray *ret)
/* Create a stringArray out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new stringArray */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->numNames = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->names, ret->numNames);
for (i=0; i<ret->numNames; ++i)
    {
    ret->names[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void stringArrayFree(struct stringArray **pEl)
/* Free a single dynamically allocated stringArray such as created
 * with stringArrayLoad(). */
{
struct stringArray *el;

if ((el = *pEl) == NULL) return;
/* All strings in names are allocated at once, so only need to free first. */
if (el->names != NULL)
    freeMem(el->names[0]);
freeMem(el->names);
freez(pEl);
}

void stringArrayFreeList(struct stringArray **pList)
/* Free a list of dynamically allocated stringArray's */
{
struct stringArray *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    stringArrayFree(&el);
    }
*pList = NULL;
}

void stringArrayOutput(struct stringArray *el, FILE *f, char sep, char lastSep) 
/* Print out stringArray.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->numNames);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->numNames; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->names[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

