/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.jstestdriver.coverage.CoverageWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoveredLine
implements Comparable<CoveredLine> {
    private int executedNumber;
    private int lineNumber;

    public CoveredLine() {
        this.executedNumber = 0;
        this.lineNumber = 0;
    }

    public CoveredLine(int lineNumber, int executedNumber) {
        this.lineNumber = lineNumber;
        this.executedNumber = executedNumber;
    }

    public int getExecutedNumber() {
        return this.executedNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public CoveredLine aggegrate(CoveredLine line) {
        if (this.lineNumber != line.lineNumber) {
            return null;
        }
        return new CoveredLine(this.lineNumber, this.executedNumber + line.executedNumber);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.executedNumber;
        result = 31 * result + this.lineNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoveredLine other = (CoveredLine)obj;
        if (this.executedNumber != other.executedNumber) {
            return false;
        }
        return this.lineNumber == other.lineNumber;
    }

    @Override
    public int compareTo(CoveredLine o) {
        return this.lineNumber - o.lineNumber;
    }

    public String toString() {
        return String.format("%s(%s, %s)", this.getClass().getSimpleName(), this.lineNumber, this.executedNumber);
    }

    public void write(CoverageWriter writer) {
        writer.writeCoverage(this.lineNumber, this.executedNumber);
    }
}

