/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.inject.Singleton;
import com.google.jstestdriver.coverage.CoverageWriter;
import com.google.jstestdriver.coverage.FileCoverage;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CoverageAccumulator {
    private ConcurrentLinkedQueue<FileCoverage> fileCoverages = new ConcurrentLinkedQueue();

    public void add(String browserId, Collection<FileCoverage> rawCoverage) {
        for (FileCoverage fileCoverage : rawCoverage) {
            this.fileCoverages.offer(fileCoverage);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileCoverages == null ? 0 : this.fileCoverages.hashCode());
        return result;
    }

    public void write(CoverageWriter coverageWriter) {
        if (!this.fileCoverages.isEmpty()) {
            LinkedList<FileCoverage> rawCoverage = new LinkedList<FileCoverage>(this.fileCoverages);
            Collections.sort(rawCoverage);
            FileCoverage last = (FileCoverage)rawCoverage.get(0);
            for (FileCoverage fileCoverage : rawCoverage.subList(1, rawCoverage.size())) {
                FileCoverage aggregate = last.aggegrate(fileCoverage);
                if (aggregate == null) {
                    last.write(coverageWriter);
                    last = fileCoverage;
                    continue;
                }
                last = aggregate;
            }
            last.write(coverageWriter);
        } else {
            System.out.println("No lines of coverage found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoverageAccumulator other = (CoverageAccumulator)obj;
        if (this.fileCoverages == null) {
            if (other.fileCoverages == null) return true;
            return false;
        }
        Class<CoverageAccumulator> clazz = CoverageAccumulator.class;
        synchronized (CoverageAccumulator.class) {
            Iterator<FileCoverage> ours = this.fileCoverages.iterator();
            Iterator<FileCoverage> theirs = other.fileCoverages.iterator();
            while (ours.hasNext() && theirs.hasNext()) {
                if (ours.next().equals(theirs.next())) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            if (!ours.hasNext() && !theirs.hasNext()) return true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.fileCoverages);
    }
}

