/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.ServletHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuitHandler
implements RequestHandler {
    private final HttpServletResponse response;
    private final SocketConnector connector;
    private final Provider<Server> cyclicalReferenceProvider;
    private final ServletHolder holder;

    @Inject
    public QuitHandler(HttpServletResponse response, SocketConnector connector, Provider<Server> cyclicalReferenceProvider, ServletHolder holder) {
        this.response = response;
        this.connector = connector;
        this.cyclicalReferenceProvider = cyclicalReferenceProvider;
        this.holder = holder;
    }

    @Override
    public void handleIt() throws IOException {
        PrintWriter writer = this.response.getWriter();
        writer.append("exiting");
        writer.flush();
        try {
            this.cyclicalReferenceProvider.get().stop();
            this.holder.doStop();
            this.connector.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

