/* orthoAlleles.c was originally generated by the autoSql program, which also 
 * generated orthoAlleles.h and orthoAlleles.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "orthoAlleles.h"


void orthoAllelesStaticLoad(char **row, struct orthoAlleles *ret)
/* Load a row from orthoAlleles table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
ret->strand = row[5][0];
ret->allele1 = row[6][0];
ret->allele1Freq = atof(row[7]);
ret->allele1Count = sqlUnsigned(row[8]);
ret->allele2 = row[9][0];
ret->allele2Freq = atof(row[10]);
ret->allele2Count = sqlUnsigned(row[11]);
ret->ortho1Chrom = row[12];
ret->ortho1ChromStart = sqlUnsigned(row[13]);
ret->ortho1ChromEnd = sqlUnsigned(row[14]);
ret->ortho1Strand = row[15][0];
ret->ortho1State = row[16];
ret->ortho2Chrom = row[17];
ret->ortho2ChromStart = sqlUnsigned(row[18]);
ret->ortho2ChromEnd = sqlUnsigned(row[19]);
ret->ortho2Strand = row[20][0];
ret->ortho2State = row[21];
}

struct orthoAlleles *orthoAllelesLoad(char **row)
/* Load a orthoAlleles from row fetched with select * from orthoAlleles
 * from database.  Dispose of this with orthoAllelesFree(). */
{
struct orthoAlleles *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
ret->strand = row[5][0];
ret->allele1 = row[6][0];
ret->allele1Freq = atof(row[7]);
ret->allele1Count = sqlUnsigned(row[8]);
ret->allele2 = row[9][0];
ret->allele2Freq = atof(row[10]);
ret->allele2Count = sqlUnsigned(row[11]);
ret->ortho1Chrom = cloneString(row[12]);
ret->ortho1ChromStart = sqlUnsigned(row[13]);
ret->ortho1ChromEnd = sqlUnsigned(row[14]);
ret->ortho1Strand = row[15][0];
ret->ortho1State = cloneString(row[16]);
ret->ortho2Chrom = cloneString(row[17]);
ret->ortho2ChromStart = sqlUnsigned(row[18]);
ret->ortho2ChromEnd = sqlUnsigned(row[19]);
ret->ortho2Strand = row[20][0];
ret->ortho2State = cloneString(row[21]);
return ret;
}

struct orthoAlleles *orthoAllelesLoadAll(char *fileName) 
/* Load all orthoAlleles from a whitespace-separated file.
 * Dispose of this with orthoAllelesFreeList(). */
{
struct orthoAlleles *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[22];

while (lineFileRow(lf, row))
    {
    el = orthoAllelesLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct orthoAlleles *orthoAllelesLoadAllByChar(char *fileName, char chopper) 
/* Load all orthoAlleles from a chopper separated file.
 * Dispose of this with orthoAllelesFreeList(). */
{
struct orthoAlleles *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[22];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = orthoAllelesLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct orthoAlleles *orthoAllelesCommaIn(char **pS, struct orthoAlleles *ret)
/* Create a orthoAlleles out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new orthoAlleles */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, &(ret->strand), sizeof(ret->strand));
sqlFixedStringComma(&s, &(ret->allele1), sizeof(ret->allele1));
ret->allele1Freq = sqlFloatComma(&s);
ret->allele1Count = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, &(ret->allele2), sizeof(ret->allele2));
ret->allele2Freq = sqlFloatComma(&s);
ret->allele2Count = sqlUnsignedComma(&s);
ret->ortho1Chrom = sqlStringComma(&s);
ret->ortho1ChromStart = sqlUnsignedComma(&s);
ret->ortho1ChromEnd = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, &(ret->ortho1Strand), sizeof(ret->ortho1Strand));
ret->ortho1State = sqlStringComma(&s);
ret->ortho2Chrom = sqlStringComma(&s);
ret->ortho2ChromStart = sqlUnsignedComma(&s);
ret->ortho2ChromEnd = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, &(ret->ortho2Strand), sizeof(ret->ortho2Strand));
ret->ortho2State = sqlStringComma(&s);
*pS = s;
return ret;
}

void orthoAllelesFree(struct orthoAlleles **pEl)
/* Free a single dynamically allocated orthoAlleles such as created
 * with orthoAllelesLoad(). */
{
struct orthoAlleles *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->ortho1Chrom);
freeMem(el->ortho1State);
freeMem(el->ortho2Chrom);
freeMem(el->ortho2State);
freez(pEl);
}

void orthoAllelesFreeList(struct orthoAlleles **pList)
/* Free a list of dynamically allocated orthoAlleles's */
{
struct orthoAlleles *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    orthoAllelesFree(&el);
    }
*pList = NULL;
}

void orthoAllelesOutput(struct orthoAlleles *el, FILE *f, char sep, char lastSep) 
/* Print out orthoAlleles.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->allele1);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->allele1Freq);
fputc(sep,f);
fprintf(f, "%u", el->allele1Count);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->allele2);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->allele2Freq);
fputc(sep,f);
fprintf(f, "%u", el->allele2Count);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ortho1Chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->ortho1ChromStart);
fputc(sep,f);
fprintf(f, "%u", el->ortho1ChromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->ortho1Strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ortho1State);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ortho2Chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->ortho2ChromStart);
fputc(sep,f);
fprintf(f, "%u", el->ortho2ChromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->ortho2Strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ortho2State);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

