/* omicia.h was originally generated by the autoSql program, which also 
 * generated omicia.c and omicia.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef OMICIA_H
#define OMICIA_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define OMICIAAUTO_NUM_COLS 7

struct omiciaAuto
/* table for OMICIA auto-generated data */
    {
    struct omiciaAuto *next;  /* Next in singly linked list. */
    unsigned short bin;	/* A field to speed indexing */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* ID for this mutation */
    unsigned score;	/* confidence score */
    char strand[2];	/* + or - */
    };

void omiciaAutoStaticLoad(char **row, struct omiciaAuto *ret);
/* Load a row from omiciaAuto table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct omiciaAuto *omiciaAutoLoad(char **row);
/* Load a omiciaAuto from row fetched with select * from omiciaAuto
 * from database.  Dispose of this with omiciaAutoFree(). */

struct omiciaAuto *omiciaAutoLoadAll(char *fileName);
/* Load all omiciaAuto from whitespace-separated file.
 * Dispose of this with omiciaAutoFreeList(). */

struct omiciaAuto *omiciaAutoLoadAllByChar(char *fileName, char chopper);
/* Load all omiciaAuto from chopper separated file.
 * Dispose of this with omiciaAutoFreeList(). */

#define omiciaAutoLoadAllByTab(a) omiciaAutoLoadAllByChar(a, '\t');
/* Load all omiciaAuto from tab separated file.
 * Dispose of this with omiciaAutoFreeList(). */

struct omiciaAuto *omiciaAutoLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all omiciaAuto from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with omiciaAutoFreeList(). */

void omiciaAutoSaveToDb(struct sqlConnection *conn, struct omiciaAuto *el, char *tableName, int updateSize);
/* Save omiciaAuto as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct omiciaAuto *omiciaAutoCommaIn(char **pS, struct omiciaAuto *ret);
/* Create a omiciaAuto out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new omiciaAuto */

void omiciaAutoFree(struct omiciaAuto **pEl);
/* Free a single dynamically allocated omiciaAuto such as created
 * with omiciaAutoLoad(). */

void omiciaAutoFreeList(struct omiciaAuto **pList);
/* Free a list of dynamically allocated omiciaAuto's */

void omiciaAutoOutput(struct omiciaAuto *el, FILE *f, char sep, char lastSep);
/* Print out omiciaAuto.  Separate fields with sep. Follow last field with lastSep. */

#define omiciaAutoTabOut(el,f) omiciaAutoOutput(el,f,'\t','\n');
/* Print out omiciaAuto as a line in a tab-separated file. */

#define omiciaAutoCommaOut(el,f) omiciaAutoOutput(el,f,',',',');
/* Print out omiciaAuto as a comma separated list including final comma. */

#define OMICIAHAND_NUM_COLS 7

struct omiciaHand
/* table for OMICIA hand curated data */
    {
    struct omiciaHand *next;  /* Next in singly linked list. */
    unsigned short bin;	/* A field to speed indexing */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* ID for this mutation */
    unsigned score;	/* confidence score */
    char strand[2];	/* + or - */
    };

void omiciaHandStaticLoad(char **row, struct omiciaHand *ret);
/* Load a row from omiciaHand table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct omiciaHand *omiciaHandLoad(char **row);
/* Load a omiciaHand from row fetched with select * from omiciaHand
 * from database.  Dispose of this with omiciaHandFree(). */

struct omiciaHand *omiciaHandLoadAll(char *fileName);
/* Load all omiciaHand from whitespace-separated file.
 * Dispose of this with omiciaHandFreeList(). */

struct omiciaHand *omiciaHandLoadAllByChar(char *fileName, char chopper);
/* Load all omiciaHand from chopper separated file.
 * Dispose of this with omiciaHandFreeList(). */

#define omiciaHandLoadAllByTab(a) omiciaHandLoadAllByChar(a, '\t');
/* Load all omiciaHand from tab separated file.
 * Dispose of this with omiciaHandFreeList(). */

struct omiciaHand *omiciaHandLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all omiciaHand from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with omiciaHandFreeList(). */

void omiciaHandSaveToDb(struct sqlConnection *conn, struct omiciaHand *el, char *tableName, int updateSize);
/* Save omiciaHand as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct omiciaHand *omiciaHandCommaIn(char **pS, struct omiciaHand *ret);
/* Create a omiciaHand out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new omiciaHand */

void omiciaHandFree(struct omiciaHand **pEl);
/* Free a single dynamically allocated omiciaHand such as created
 * with omiciaHandLoad(). */

void omiciaHandFreeList(struct omiciaHand **pList);
/* Free a list of dynamically allocated omiciaHand's */

void omiciaHandOutput(struct omiciaHand *el, FILE *f, char sep, char lastSep);
/* Print out omiciaHand.  Separate fields with sep. Follow last field with lastSep. */

#define omiciaHandTabOut(el,f) omiciaHandOutput(el,f,'\t','\n');
/* Print out omiciaHand as a line in a tab-separated file. */

#define omiciaHandCommaOut(el,f) omiciaHandOutput(el,f,',',',');
/* Print out omiciaHand as a comma separated list including final comma. */

#define OMICIALINK_NUM_COLS 5

struct omiciaLink
/* links */
    {
    struct omiciaLink *next;  /* Next in singly linked list. */
    char *id;	/* id into the omicia composite table */
    char *attrType;	/* attribute type */
    char *raKey;	/* key into .ra file on how to do link */
    char *acc;	/* accession or id used by link */
    char *displayVal;	/* value to display if different from acc */
    };

void omiciaLinkStaticLoad(char **row, struct omiciaLink *ret);
/* Load a row from omiciaLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct omiciaLink *omiciaLinkLoad(char **row);
/* Load a omiciaLink from row fetched with select * from omiciaLink
 * from database.  Dispose of this with omiciaLinkFree(). */

struct omiciaLink *omiciaLinkLoadAll(char *fileName);
/* Load all omiciaLink from whitespace-separated file.
 * Dispose of this with omiciaLinkFreeList(). */

struct omiciaLink *omiciaLinkLoadAllByChar(char *fileName, char chopper);
/* Load all omiciaLink from chopper separated file.
 * Dispose of this with omiciaLinkFreeList(). */

#define omiciaLinkLoadAllByTab(a) omiciaLinkLoadAllByChar(a, '\t');
/* Load all omiciaLink from tab separated file.
 * Dispose of this with omiciaLinkFreeList(). */

struct omiciaLink *omiciaLinkLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all omiciaLink from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with omiciaLinkFreeList(). */

void omiciaLinkSaveToDb(struct sqlConnection *conn, struct omiciaLink *el, char *tableName, int updateSize);
/* Save omiciaLink as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct omiciaLink *omiciaLinkCommaIn(char **pS, struct omiciaLink *ret);
/* Create a omiciaLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new omiciaLink */

void omiciaLinkFree(struct omiciaLink **pEl);
/* Free a single dynamically allocated omiciaLink such as created
 * with omiciaLinkLoad(). */

void omiciaLinkFreeList(struct omiciaLink **pList);
/* Free a list of dynamically allocated omiciaLink's */

void omiciaLinkOutput(struct omiciaLink *el, FILE *f, char sep, char lastSep);
/* Print out omiciaLink.  Separate fields with sep. Follow last field with lastSep. */

#define omiciaLinkTabOut(el,f) omiciaLinkOutput(el,f,'\t','\n');
/* Print out omiciaLink as a line in a tab-separated file. */

#define omiciaLinkCommaOut(el,f) omiciaLinkOutput(el,f,',',',');
/* Print out omiciaLink as a comma separated list including final comma. */

#define OMICIAATTR_NUM_COLS 3

struct omiciaAttr
/* attributes */
    {
    struct omiciaAttr *next;  /* Next in singly linked list. */
    char *id;	/* id into the omicia composite table */
    char *attrType;	/* attribute type, label */
    char *attrVal;	/* value for this attribute */
    };

void omiciaAttrStaticLoad(char **row, struct omiciaAttr *ret);
/* Load a row from omiciaAttr table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct omiciaAttr *omiciaAttrLoad(char **row);
/* Load a omiciaAttr from row fetched with select * from omiciaAttr
 * from database.  Dispose of this with omiciaAttrFree(). */

struct omiciaAttr *omiciaAttrLoadAll(char *fileName);
/* Load all omiciaAttr from whitespace-separated file.
 * Dispose of this with omiciaAttrFreeList(). */

struct omiciaAttr *omiciaAttrLoadAllByChar(char *fileName, char chopper);
/* Load all omiciaAttr from chopper separated file.
 * Dispose of this with omiciaAttrFreeList(). */

#define omiciaAttrLoadAllByTab(a) omiciaAttrLoadAllByChar(a, '\t');
/* Load all omiciaAttr from tab separated file.
 * Dispose of this with omiciaAttrFreeList(). */

struct omiciaAttr *omiciaAttrLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all omiciaAttr from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with omiciaAttrFreeList(). */

void omiciaAttrSaveToDb(struct sqlConnection *conn, struct omiciaAttr *el, char *tableName, int updateSize);
/* Save omiciaAttr as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct omiciaAttr *omiciaAttrCommaIn(char **pS, struct omiciaAttr *ret);
/* Create a omiciaAttr out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new omiciaAttr */

void omiciaAttrFree(struct omiciaAttr **pEl);
/* Free a single dynamically allocated omiciaAttr such as created
 * with omiciaAttrLoad(). */

void omiciaAttrFreeList(struct omiciaAttr **pList);
/* Free a list of dynamically allocated omiciaAttr's */

void omiciaAttrOutput(struct omiciaAttr *el, FILE *f, char sep, char lastSep);
/* Print out omiciaAttr.  Separate fields with sep. Follow last field with lastSep. */

#define omiciaAttrTabOut(el,f) omiciaAttrOutput(el,f,'\t','\n');
/* Print out omiciaAttr as a line in a tab-separated file. */

#define omiciaAttrCommaOut(el,f) omiciaAttrOutput(el,f,',',',');
/* Print out omiciaAttr as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* OMICIA_H */

