/* borkPseudoHom.c was originally generated by the autoSql program, which also 
 * generated borkPseudoHom.h and borkPseudoHom.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "borkPseudoHom.h"


void borkPseudoHomStaticLoad(char **row, struct borkPseudoHom *ret)
/* Load a row from borkPseudoHom table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->protRef = row[1];
ret->description = row[2];
}

struct borkPseudoHom *borkPseudoHomLoad(char **row)
/* Load a borkPseudoHom from row fetched with select * from borkPseudoHom
 * from database.  Dispose of this with borkPseudoHomFree(). */
{
struct borkPseudoHom *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->protRef = cloneString(row[1]);
ret->description = cloneString(row[2]);
return ret;
}

struct borkPseudoHom *borkPseudoHomLoadAll(char *fileName) 
/* Load all borkPseudoHom from a tab-separated file.
 * Dispose of this with borkPseudoHomFreeList(). */
{
struct borkPseudoHom *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = borkPseudoHomLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct borkPseudoHom *borkPseudoHomLoadWhere(struct sqlConnection *conn, char *table, char *where)
/* Load all borkPseudoHom from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with borkPseudoHomFreeList(). */
{
struct borkPseudoHom *list = NULL, *el;
struct dyString *query = dyStringNew(256);
struct sqlResult *sr;
char **row;

sqlDyStringPrintf(query, "select * from %s", table);
if (where != NULL)
    sqlDyStringPrintf(query, " where %-s", where);
sr = sqlGetResult(conn, query->string);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = borkPseudoHomLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
dyStringFree(&query);
return list;
}

struct borkPseudoHom *borkPseudoHomCommaIn(char **pS, struct borkPseudoHom *ret)
/* Create a borkPseudoHom out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new borkPseudoHom */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->protRef = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void borkPseudoHomFree(struct borkPseudoHom **pEl)
/* Free a single dynamically allocated borkPseudoHom such as created
 * with borkPseudoHomLoad(). */
{
struct borkPseudoHom *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->protRef);
freeMem(el->description);
freez(pEl);
}

void borkPseudoHomFreeList(struct borkPseudoHom **pList)
/* Free a list of dynamically allocated borkPseudoHom's */
{
struct borkPseudoHom *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    borkPseudoHomFree(&el);
    }
*pList = NULL;
}

void borkPseudoHomOutput(struct borkPseudoHom *el, FILE *f, char sep, char lastSep) 
/* Print out borkPseudoHom.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->protRef);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

