/* lowelabPfamHit.h was originally generated by the autoSql program, which also 
 * generated lowelabPfamHit.c and lowelabPfamHit.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef LOWELABPFAMHIT_H
#define LOWELABPFAMHIT_H

#define LOWELABPFAMHITS_NUM_COLS 12

struct lowelabPfamHits
/* Pfam domain hits mapped to the genome */
    {
    struct lowelabPfamHits *next;  /* Next in singly linked list. */
    char *chrom;	/* chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* hit name */
    unsigned score;	/* Score from 900-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    char *pfamAC;	/* Pfam accession number */
    char *pfamID;	/* Pfam ID */
    char *swissAC;	/* SWISS-PROT accession number */
    char *protCoord;	/* Coordiates of Pfam domain hit within organism protein */
    unsigned ident;	/* Percent identity of Pfam-A seq with this hit (should be >90%) */
    unsigned percLen;	/* Percent length of Pfam domain relative to protein length) */
    };

void lowelabPfamHitsStaticLoad(char **row, struct lowelabPfamHits *ret);
/* Load a row from lowelabPfamHits table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct lowelabPfamHits *lowelabPfamHitsLoad(char **row);
/* Load a lowelabPfamHits from row fetched with select * from lowelabPfamHits
 * from database.  Dispose of this with lowelabPfamHitsFree(). */

struct lowelabPfamHits *lowelabPfamHitsLoadAll(char *fileName);
/* Load all lowelabPfamHits from whitespace-separated file.
 * Dispose of this with lowelabPfamHitsFreeList(). */

struct lowelabPfamHits *lowelabPfamHitsLoadAllByChar(char *fileName, char chopper);
/* Load all lowelabPfamHits from chopper separated file.
 * Dispose of this with lowelabPfamHitsFreeList(). */

#define lowelabPfamHitsLoadAllByTab(a) lowelabPfamHitsLoadAllByChar(a, '\t');
/* Load all lowelabPfamHits from tab separated file.
 * Dispose of this with lowelabPfamHitsFreeList(). */

struct lowelabPfamHits *lowelabPfamHitsCommaIn(char **pS, struct lowelabPfamHits *ret);
/* Create a lowelabPfamHits out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new lowelabPfamHits */

void lowelabPfamHitsFree(struct lowelabPfamHits **pEl);
/* Free a single dynamically allocated lowelabPfamHits such as created
 * with lowelabPfamHitsLoad(). */

void lowelabPfamHitsFreeList(struct lowelabPfamHits **pList);
/* Free a list of dynamically allocated lowelabPfamHits's */

void lowelabPfamHitsOutput(struct lowelabPfamHits *el, FILE *f, char sep, char lastSep);
/* Print out lowelabPfamHits.  Separate fields with sep. Follow last field with lastSep. */

#define lowelabPfamHitsTabOut(el,f) lowelabPfamHitsOutput(el,f,'\t','\n');
/* Print out lowelabPfamHits as a line in a tab-separated file. */

#define lowelabPfamHitsCommaOut(el,f) lowelabPfamHitsOutput(el,f,',',',');
/* Print out lowelabPfamHits as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* LOWELABPFAMHIT_H */

