/* affyTransLifted.h was originally generated by the autoSql program, which also 
 * generated affyTransLifted.c and affyTransLifted.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2002 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef AFFYTRANSLIFTED_H
#define AFFYTRANSLIFTED_H

struct affyTransLifted
/* Data file format for Affymetrix transcriptome data from Simon Cawley which has been normalized and lifted to a new assembly of the human genome. */
    {
    struct affyTransLifted *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome in hs.NCBIfreeze.chrom fomat originally */
    unsigned chromPos;	/* Coordinate in chromosome (location of central base of the 25-mer) */
    int xCoord;	/* x-coordinate (column) of PM feature on chip */
    int yCoord;	/* y-coordinate (row) of PM feature on chip */
    int rawPM;	/* raw value of PM */
    int rawMM;	/* raw value of MM */
    float normPM;	/* normalized value of PM */
    float normMM;	/* normalized value of MM */
    };

void affyTransLiftedStaticLoad(char **row, struct affyTransLifted *ret);
/* Load a row from affyTransLifted table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct affyTransLifted *affyTransLiftedLoad(char **row);
/* Load a affyTransLifted from row fetched with select * from affyTransLifted
 * from database.  Dispose of this with affyTransLiftedFree(). */

struct affyTransLifted *affyTransLiftedLoadAll(char *fileName);
/* Load all affyTransLifted from a tab-separated file.
 * Dispose of this with affyTransLiftedFreeList(). */

struct affyTransLifted *affyTransLiftedCommaIn(char **pS, struct affyTransLifted *ret);
/* Create a affyTransLifted out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new affyTransLifted */

void affyTransLiftedFree(struct affyTransLifted **pEl);
/* Free a single dynamically allocated affyTransLifted such as created
 * with affyTransLiftedLoad(). */

void affyTransLiftedFreeList(struct affyTransLifted **pList);
/* Free a list of dynamically allocated affyTransLifted's */

void affyTransLiftedOutput(struct affyTransLifted *el, FILE *f, char sep, char lastSep);
/* Print out affyTransLifted.  Separate fields with sep. Follow last field with lastSep. */

#define affyTransLiftedTabOut(el,f) affyTransLiftedOutput(el,f,'\t','\n');
/* Print out affyTransLifted as a line in a tab-separated file. */

#define affyTransLiftedCommaOut(el,f) affyTransLiftedOutput(el,f,',',',');
/* Print out affyTransLifted as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* AFFYTRANSLIFTED_H */

