/* jaxQTL3.c was originally generated by the autoSql program, which also 
 * generated jaxQTL3.h and jaxQTL3.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "jaxQTL3.h"


void jaxQTL3StaticLoad(char **row, struct jaxQTL3 *ret)
/* Load a row from jaxQTL3 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->marker = row[8];
ret->mgiID = row[9];
ret->description = row[10];
ret->cMscore = atof(row[11]);
ret->flank1 = row[12];
ret->flank2 = row[13];
}

struct jaxQTL3 *jaxQTL3Load(char **row)
/* Load a jaxQTL3 from row fetched with select * from jaxQTL3
 * from database.  Dispose of this with jaxQTL3Free(). */
{
struct jaxQTL3 *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->marker = cloneString(row[8]);
ret->mgiID = cloneString(row[9]);
ret->description = cloneString(row[10]);
ret->cMscore = atof(row[11]);
ret->flank1 = cloneString(row[12]);
ret->flank2 = cloneString(row[13]);
return ret;
}

struct jaxQTL3 *jaxQTL3LoadAll(char *fileName) 
/* Load all jaxQTL3 from a whitespace-separated file.
 * Dispose of this with jaxQTL3FreeList(). */
{
struct jaxQTL3 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = jaxQTL3Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct jaxQTL3 *jaxQTL3LoadAllByChar(char *fileName, char chopper) 
/* Load all jaxQTL3 from a chopper separated file.
 * Dispose of this with jaxQTL3FreeList(). */
{
struct jaxQTL3 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = jaxQTL3Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct jaxQTL3 *jaxQTL3CommaIn(char **pS, struct jaxQTL3 *ret)
/* Create a jaxQTL3 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new jaxQTL3 */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->marker = sqlStringComma(&s);
ret->mgiID = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->cMscore = sqlFloatComma(&s);
ret->flank1 = sqlStringComma(&s);
ret->flank2 = sqlStringComma(&s);
*pS = s;
return ret;
}

void jaxQTL3Free(struct jaxQTL3 **pEl)
/* Free a single dynamically allocated jaxQTL3 such as created
 * with jaxQTL3Load(). */
{
struct jaxQTL3 *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->marker);
freeMem(el->mgiID);
freeMem(el->description);
freeMem(el->flank1);
freeMem(el->flank2);
freez(pEl);
}

void jaxQTL3FreeList(struct jaxQTL3 **pList)
/* Free a list of dynamically allocated jaxQTL3's */
{
struct jaxQTL3 *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    jaxQTL3Free(&el);
    }
*pList = NULL;
}

void jaxQTL3Output(struct jaxQTL3 *el, FILE *f, char sep, char lastSep) 
/* Print out jaxQTL3.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->marker);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mgiID);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->cMscore);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->flank1);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->flank2);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

