table clinGenCnv
"CNVs from NCBI Clinical Genome Resource"
    (
    string chrom;      "Reference sequence chromosome or scaffold"
    uint   chromStart; "Start position in chromosome"
    uint   chromEnd;   "End position in chromosome"
    string name;       "Short Name of item"
    uint   score;      "Score from 0-1000"
    char[1] strand;    "+ or -"
    uint thickStart;   "Start of where display should be thick (start codon)"
    uint thickEnd;     "End of where display should be thick (stop codon)"
    uint reserved;     "Used as itemRgb as of 2004-11-22"
    uint size;         "Size of variant"
    string alias; "Item Alias"
    string variantRegion; "Variant Region"
    string startRange; "Start Range"
    string endRange; "End Range"
    string copyNumber; "Copy Number"
    string variantType; "Variant Type"
    string omimId; "OMIM ID(s)"
    string clinGenId; "ClinGen ID(s)"
    string phenotype; "Phenotype"
    string phenotypeId; "Phenotype ID(s)"
    lstring pubMed; "PubMed ID(s)"
    string clinicalInterpretation; "Clinical Interpretation"
    string clinicalSource; "Clinical Source"
    string sampleName; "Sample Name"
    string samplesetName; "Sampleset Name"
    lstring _mouseOver; "mouseOver string"
    )
