table crispr
"CRISPR guides: bed9+, external fields in a tab-sep file with blobs for off-targets"
   (
   string chrom;       "Reference sequence chromosome or scaffold"
   uint   chromStart;  "Start position in chromosome"
   uint   chromEnd;    "End position in chromosome"
   string name;        "Name or ID of item, ideally both human readable and unique"
   uint score;         "Score (0-1000)"
   char[1] strand;     "+ or - for strand"
   uint thickStart;    "Start of where display should be thick (start codon)"
   uint thickEnd;      "End of where display should be thick (stop codon)"
   uint reserved;       "Doench 2016 / Fusi et al. Score"
   string _crisprScanColor;    "Moreno-Mateos Score"
   string _specColor;    "MIT Specificity Score"
   string guideSeq;     "Guide Sequence"
   string pam;          "Protospacer Adjacent Motif (PAM)"
   string scoreDesc;    "MIT Guide Specificity Score"
   string fusi;         "Efficiency: Doench et al. 2016 Score Percentile"
   string crisprScan;   "Efficiency: Moreno-Mateos (In-vitro) Score Percentile"
   string doench;       "Efficiency: Doench et al 2014 Score"
   string oof;          "Bae et al. Out-of-Frame Score"
   string _mouseOver;    "Label for Mouse-over"
   bigint _offset;        "Offset into tab-sep file for details page"
   )
