# knownMore.sql was originally generated by the autoSql program, which also 
# generated knownMore.c and knownMore.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Lots of auxiliary info about a known gene
CREATE TABLE knownMore (
    name varchar(255) not null,	# The name displayed in the browser: OMIM, gbGeneName, or transId
    transId varchar(255) not null,	# Transcript id. Genie generated ID.
    geneId varchar(255) not null,	# Gene (not transcript) Genie ID
    gbGeneName int unsigned not null,	# Connect to geneName table. Genbank gene name
    gbProductName int unsigned not null,	# Connects to productName table. Genbank product name
    gbProteinAcc varchar(255) not null,	# Genbank accession of protein
    gbNgi varchar(255) not null,	# Genbank gi of nucleotide seq.
    gbPgi varchar(255) not null,	# Genbank gi of protein seq.
    omimId int unsigned not null,	# OMIM ID or 0 if none
    omimName varchar(255) not null,	# OMIM primary name
    hugoId int unsigned not null,	# HUGO Nomeclature Committee ID or 0 if none
    hugoSymbol varchar(255) not null,	# HUGO short name
    hugoName varchar(255) not null,	# HUGO descriptive name
    hugoMap varchar(255) not null,	# HUGO Map position
    pmId1 int unsigned not null,	# I have no idea - grabbed from a HUGO nomeids.txt
    pmId2 int unsigned not null,	# Likewise, I have no idea
    refSeqAcc varchar(255) not null,	# Accession of RefSeq mRNA
    aliases varchar(255) not null,	# Aliases if any.  Comma and space separated list
    locusLinkId int unsigned not null,	# Locus link ID
    gdbId varchar(255) not null,	# NCBI GDB database ID
              #Indices
    INDEX(name(24)),
    PRIMARY KEY(transId(24)),
    INDEX(omimId),
    INDEX(hugoId),
    INDEX(hugoSymbol(16)),
    INDEX(refSeqAcc(16))
);
