# hgnc.sql was originally generated by the autoSql program, which also 
# generated hgnc.c and hgnc.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#A cross-reference table between HUGO Gene Nomenclature Committee (HGNC) IDs and other database IDs.
CREATE TABLE hgnc (
    hgncId varchar(255),	# HGNC ID
    symbol varchar(255),	# Approved Symbol
    name varchar(255),	# Approved Name
    status varchar(255),	# Status
    locusType varchar(255),	# Locus Type
    locusGroup varchar(255),	# Locus Group
    prvSymbols varchar(255),	# Previous Symbols
    prvNames longblob,	# Previous Names
    synonyms varchar(255),	# Synonyms
    nameSyns longblob,	# Name synonyms
    chrom varchar(255),	# Reference sequence chromosome or scaffold
    dateApprv varchar(255),	# Date Approved
    dateMod varchar(255),	# Date Modified
    dateSymChange varchar(255),	# Date Symbol Changed
    dateNmChange varchar(255),	# Date Name Changed
    accession varchar(255),	# Accession Numbers
    enzymeIds varchar(255),	# Enzyme IDs
    entrezId varchar(255),	# Entrez Gene ID
    ensId varchar(255),	# Ensembl Gene ID
    mgdId varchar(255),	# MGD ID
    miscDbs longblob,	# Misc Database Links
    miscIds varchar(255),	# Misc Database IDs
    pubMed varchar(255),	# Pubmed IDs
    refSeqIds varchar(255),	# RefSeq IDs
    geneFamilyNm varchar(255),	# Gene Family Name
    geneFamilyDesc varchar(255),	# Gene Family Description
    recType varchar(255),	# Record Type
    primaryId varchar(255),	# Primary ID
    secondaryId varchar(255),	# Secondary ID
    ccdsId varchar(255),	# CCDS ID
    vegaId varchar(255),	# Vega ID
    locusDbs longblob,	# Locus-Specific Databases
    gdbMapped varchar(255),	# GDB ID (mapped data)
    entrezMapped varchar(255),	# Entrez Gene ID (mapped data)
    omimMapped varchar(255),	# OMIM ID (mapped data)
    refSeqMapped varchar(255),	# RefSeq (mapped data)
    uniProtMapped varchar(255),	# UniProt ID (mapped data)
    ensMapped varchar(255),	# ENSEMLB ID (mapped data)
    ucscMapped varchar(255),	# UCSC ID (mapped data)
    mgiMapped varchar(255),	# MGD ID (mapped data)
    rgdMapped varchar(255),	# Rat genome database ID (mapped data)
              #Indices
    PRIMARY KEY(hgncId)
);
