/* gtexSampleData.c was originally generated by the autoSql program, which also 
 * generated gtexSampleData.h and gtexSampleData.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gtexSampleData.h"



char *gtexSampleDataCommaSepFieldNames = "geneId,sample,tissue,score";

void gtexSampleDataStaticLoad(char **row, struct gtexSampleData *ret)
/* Load a row from gtexSampleData table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->geneId = row[0];
ret->sample = row[1];
ret->tissue = row[2];
ret->score = sqlFloat(row[3]);
}

struct gtexSampleData *gtexSampleDataLoad(char **row)
/* Load a gtexSampleData from row fetched with select * from gtexSampleData
 * from database.  Dispose of this with gtexSampleDataFree(). */
{
struct gtexSampleData *ret;

AllocVar(ret);
ret->geneId = cloneString(row[0]);
ret->sample = cloneString(row[1]);
ret->tissue = cloneString(row[2]);
ret->score = sqlFloat(row[3]);
return ret;
}

struct gtexSampleData *gtexSampleDataLoadAll(char *fileName) 
/* Load all gtexSampleData from a whitespace-separated file.
 * Dispose of this with gtexSampleDataFreeList(). */
{
struct gtexSampleData *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = gtexSampleDataLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexSampleData *gtexSampleDataLoadAllByChar(char *fileName, char chopper) 
/* Load all gtexSampleData from a chopper separated file.
 * Dispose of this with gtexSampleDataFreeList(). */
{
struct gtexSampleData *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gtexSampleDataLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexSampleData *gtexSampleDataCommaIn(char **pS, struct gtexSampleData *ret)
/* Create a gtexSampleData out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexSampleData */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->geneId = sqlStringComma(&s);
ret->sample = sqlStringComma(&s);
ret->tissue = sqlStringComma(&s);
ret->score = sqlFloatComma(&s);
*pS = s;
return ret;
}

void gtexSampleDataFree(struct gtexSampleData **pEl)
/* Free a single dynamically allocated gtexSampleData such as created
 * with gtexSampleDataLoad(). */
{
struct gtexSampleData *el;

if ((el = *pEl) == NULL) return;
freeMem(el->geneId);
freeMem(el->sample);
freeMem(el->tissue);
freez(pEl);
}

void gtexSampleDataFreeList(struct gtexSampleData **pList)
/* Free a list of dynamically allocated gtexSampleData's */
{
struct gtexSampleData *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gtexSampleDataFree(&el);
    }
*pList = NULL;
}

void gtexSampleDataOutput(struct gtexSampleData *el, FILE *f, char sep, char lastSep) 
/* Print out gtexSampleData.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sample);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tissue);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->score);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void gtexSampleDataCreateTable(struct sqlConnection *conn, char *table)
/* Create expression record format table of given name. */
{
char query[1024];

sqlSafef(query, sizeof(query),
"CREATE TABLE %s (\n"
"    geneId varchar(255) not null,     # Gene identifier (ensembl)\n"
"    sample varchar(255) not null,     # GTEx sample identifier\n"
"    tissue varchar(255) not null,     # Tissue name\n"
"    score float not null,	# Expression level (RPKM)\n"
"              #Indices\n"
"    KEY(geneId),\n"
"    KEY(tissue)\n"
")\n",   table);
sqlRemakeTable(conn, table, query);
}
