/* gbExtFile.c was originally generated by the autoSql program, which also 
 * generated gbExtFile.h and gbExtFile.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gbExtFile.h"


void gbExtFileStaticLoad(char **row, struct gbExtFile *ret)
/* Load a row from gbExtFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->path = row[1];
ret->size = sqlUnsigned(row[2]);
}

struct gbExtFile *gbExtFileLoad(char **row)
/* Load a gbExtFile from row fetched with select * from gbExtFile
 * from database.  Dispose of this with gbExtFileFree(). */
{
struct gbExtFile *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->path = cloneString(row[1]);
ret->size = sqlUnsigned(row[2]);
return ret;
}

struct gbExtFile *gbExtFileLoadAll(char *fileName) 
/* Load all gbExtFile from a whitespace-separated file.
 * Dispose of this with gbExtFileFreeList(). */
{
struct gbExtFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = gbExtFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gbExtFile *gbExtFileLoadAllByChar(char *fileName, char chopper) 
/* Load all gbExtFile from a chopper separated file.
 * Dispose of this with gbExtFileFreeList(). */
{
struct gbExtFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gbExtFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gbExtFile *gbExtFileCommaIn(char **pS, struct gbExtFile *ret)
/* Create a gbExtFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gbExtFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->path = sqlStringComma(&s);
ret->size = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void gbExtFileFree(struct gbExtFile **pEl)
/* Free a single dynamically allocated gbExtFile such as created
 * with gbExtFileLoad(). */
{
struct gbExtFile *el;

if ((el = *pEl) == NULL) return;
freeMem(el->path);
freez(pEl);
}

void gbExtFileFreeList(struct gbExtFile **pList)
/* Free a list of dynamically allocated gbExtFile's */
{
struct gbExtFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gbExtFileFree(&el);
    }
*pList = NULL;
}

void gbExtFileOutput(struct gbExtFile *el, FILE *f, char sep, char lastSep) 
/* Print out gbExtFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->path);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->size);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

