/* factorSource.h was originally generated by the autoSql program, which also 
 * generated factorSource.c and factorSource.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef FACTORSOURCE_H
#define FACTORSOURCE_H

#define FACTORSOURCE_NUM_COLS 8

extern char *factorSourceCommaSepFieldNames;

struct factorSource
/* BED5+ with two fields having variable number of experiment IDs and values (none zero-valued) */
    {
    struct factorSource *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* Score from 0-1000 */
    unsigned expCount;	/* Number of experiment values */
    unsigned *expNums;	/* Comma separated list of experiment numbers */
    float *expScores;	/* Comma separated list of experiment scores */
    };

struct factorSource *factorSourceLoad(char **row);
/* Load a factorSource from row fetched with select * from factorSource
 * from database.  Dispose of this with factorSourceFree(). */

struct factorSource *factorSourceLoadAll(char *fileName);
/* Load all factorSource from whitespace-separated file.
 * Dispose of this with factorSourceFreeList(). */

struct factorSource *factorSourceLoadAllByChar(char *fileName, char chopper);
/* Load all factorSource from chopper separated file.
 * Dispose of this with factorSourceFreeList(). */

#define factorSourceLoadAllByTab(a) factorSourceLoadAllByChar(a, '\t');
/* Load all factorSource from tab separated file.
 * Dispose of this with factorSourceFreeList(). */

void factorSourceFree(struct factorSource **pEl);
/* Free a single dynamically allocated factorSource such as created
 * with factorSourceLoad(). */

void factorSourceFreeList(struct factorSource **pList);
/* Free a list of dynamically allocated factorSource's */

void factorSourceOutput(struct factorSource *el, FILE *f, char sep, char lastSep);
/* Print out factorSource.  Separate fields with sep. Follow last field with lastSep. */

#define factorSourceTabOut(el,f) factorSourceOutput(el,f,'\t','\n');
/* Print out factorSource as a line in a tab-separated file. */

#define factorSourceCommaOut(el,f) factorSourceOutput(el,f,',',',');
/* Print out factorSource as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct asObject *factorSourceAsObj();
/* Return asObject describing fields of factorSource */

#endif /* FACTORSOURCE_H */

