/* bedMethyl.h was originally generated by the autoSql program, which also 
 * generated bedMethyl.c and bedMethyl.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BEDMETHYL_H
#define BEDMETHYL_H

#include "jksql.h"
#define BEDMETHYL_NUM_COLS 18

extern char *bedMethylCommaSepFieldNames;

struct bedMethyl
/* Browser extensible data for bedmethyl files (bed9+9) */
    {
    struct bedMethyl *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome (or contig, scaffold, etc.) */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* Score from 0-1000 */
    char strand[2];	/* + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* Used as itemRgb as of 2004-11-22 */
    char *nValidCov;	/* Valid Coverage|N_mod + N_otherMod + N_canonical */
    char *percMod;	/* Percent Modified */
    char *nMod;	/* N_mod|Number of calls with a modified base */
    char *nCanon;	/* N_canonical|Number of calls with a canonical base */
    char *nOther;	/* N_otherMod|Number of calls with a modified base, other modification */
    char *nDelete;	/* N_delete|Number of reads with a deletion at this reference position */
    char *nFail;	/* N_fail|Number of calls where the probability of the call was below the threshold.  */
    char *nDiff;	/* N_diff|Number of reads with a base other than the canonical base for this modification.  */
    char *nNoCall;	/* N_nocall|Number of reads aligned to this reference position, with the correct canonical base, but without a base modification call. */
    };

void bedMethylStaticLoad(char **row, struct bedMethyl *ret);
/* Load a row from bedMethyl table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bedMethyl *bedMethylLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all bedMethyl from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with bedMethylFreeList(). */

void bedMethylSaveToDb(struct sqlConnection *conn, struct bedMethyl *el, char *tableName, int updateSize);
/* Save bedMethyl as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct bedMethyl *bedMethylLoad(char **row);
/* Load a bedMethyl from row fetched with select * from bedMethyl
 * from database.  Dispose of this with bedMethylFree(). */

struct bedMethyl *bedMethylLoadAll(char *fileName);
/* Load all bedMethyl from whitespace-separated file.
 * Dispose of this with bedMethylFreeList(). */

struct bedMethyl *bedMethylLoadAllByChar(char *fileName, char chopper);
/* Load all bedMethyl from chopper separated file.
 * Dispose of this with bedMethylFreeList(). */

#define bedMethylLoadAllByTab(a) bedMethylLoadAllByChar(a, '\t');
/* Load all bedMethyl from tab separated file.
 * Dispose of this with bedMethylFreeList(). */

struct bedMethyl *bedMethylCommaIn(char **pS, struct bedMethyl *ret);
/* Create a bedMethyl out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bedMethyl */

void bedMethylFree(struct bedMethyl **pEl);
/* Free a single dynamically allocated bedMethyl such as created
 * with bedMethylLoad(). */

void bedMethylFreeList(struct bedMethyl **pList);
/* Free a list of dynamically allocated bedMethyl's */

void bedMethylOutput(struct bedMethyl *el, FILE *f, char sep, char lastSep);
/* Print out bedMethyl.  Separate fields with sep. Follow last field with lastSep. */

#define bedMethylTabOut(el,f) bedMethylOutput(el,f,'\t','\n');
/* Print out bedMethyl as a line in a tab-separated file. */

#define bedMethylCommaOut(el,f) bedMethylOutput(el,f,',',',');
/* Print out bedMethyl as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct asObject *bedMethylAsObj();
/* Return asObject describing fields of bedMethyl object */
#endif /* BEDMETHYL_H */

