/* affyTranscriptome.h was originally generated by the autoSql program, which also 
 * generated affyTranscriptome.c and affyTranscriptome.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef AFFYTRANSCRIPTOME_H
#define AFFYTRANSCRIPTOME_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define AFFYTRANSCRIPTOME_NUM_COLS 9

struct affyTranscriptome
/* Affymetrix Transcriptome */
    {
    struct affyTranscriptome *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start in Chromosome */
    unsigned chromEnd;	/* End in Chromosome */
    char *name;	/* Name */
    unsigned score;	/* Score */
    char strand[2];	/* Strand */
    unsigned sampleCount;	/* Number of points in this record */
    char *samplePosition;	/* Posititions of the oligos */
    char *sampleHeight;	/* Intentisy of hybridization */
    };

void affyTranscriptomeStaticLoad(char **row, struct affyTranscriptome *ret);
/* Load a row from affyTranscriptome table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct affyTranscriptome *affyTranscriptomeLoad(char **row);
/* Load a affyTranscriptome from row fetched with select * from affyTranscriptome
 * from database.  Dispose of this with affyTranscriptomeFree(). */

struct affyTranscriptome *affyTranscriptomeLoadAll(char *fileName);
/* Load all affyTranscriptome from whitespace-separated file.
 * Dispose of this with affyTranscriptomeFreeList(). */

struct affyTranscriptome *affyTranscriptomeLoadAllByChar(char *fileName, char chopper);
/* Load all affyTranscriptome from chopper separated file.
 * Dispose of this with affyTranscriptomeFreeList(). */

#define affyTranscriptomeLoadAllByTab(a) affyTranscriptomeLoadAllByChar(a, '\t');
/* Load all affyTranscriptome from tab separated file.
 * Dispose of this with affyTranscriptomeFreeList(). */

struct affyTranscriptome *affyTranscriptomeLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all affyTranscriptome from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with affyTranscriptomeFreeList(). */

void affyTranscriptomeSaveToDb(struct sqlConnection *conn, struct affyTranscriptome *el, char *tableName, int updateSize);
/* Save affyTranscriptome as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct affyTranscriptome *affyTranscriptomeCommaIn(char **pS, struct affyTranscriptome *ret);
/* Create a affyTranscriptome out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new affyTranscriptome */

void affyTranscriptomeFree(struct affyTranscriptome **pEl);
/* Free a single dynamically allocated affyTranscriptome such as created
 * with affyTranscriptomeLoad(). */

void affyTranscriptomeFreeList(struct affyTranscriptome **pList);
/* Free a list of dynamically allocated affyTranscriptome's */

void affyTranscriptomeOutput(struct affyTranscriptome *el, FILE *f, char sep, char lastSep);
/* Print out affyTranscriptome.  Separate fields with sep. Follow last field with lastSep. */

#define affyTranscriptomeTabOut(el,f) affyTranscriptomeOutput(el,f,'\t','\n');
/* Print out affyTranscriptome as a line in a tab-separated file. */

#define affyTranscriptomeCommaOut(el,f) affyTranscriptomeOutput(el,f,',',',');
/* Print out affyTranscriptome as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* AFFYTRANSCRIPTOME_H */

