/* adjacency.h was originally generated by the autoSql program, which also 
 * generated adjacency.c and adjacency.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef ADJACENCY_H
#define ADJACENCY_H

#define ADJACENCY_NUM_COLS 9

extern char *adjacencyCommaSepFieldNames;

struct adjacency
/* new adjacency */
    {
    struct adjacency *next;  /* Next in singly linked list. */
    char *chrom;	/* First chrom */
    unsigned chromStart;	/* position in first chromosome */
    unsigned chromEnd;	/* position in second chromosome */
    char *name;	/* Second chrom */
    unsigned score;	/* Score from 0-1000 */
    char strand1[2];	/* + or - */
    char strand2[2];	/* + or - */
    char *cycle;	/* Cycle name */
    unsigned ordering;	/* Ordering */
    unsigned level;
    };

void adjacencyStaticLoad(char **row, struct adjacency *ret);
/* Load a row from adjacency table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct adjacency *adjacencyLoad(char **row);
/* Load a adjacency from row fetched with select * from adjacency
 * from database.  Dispose of this with adjacencyFree(). */

struct adjacency *adjacencyLoadAll(char *fileName);
/* Load all adjacency from whitespace-separated file.
 * Dispose of this with adjacencyFreeList(). */

struct adjacency *adjacencyLoadAllByChar(char *fileName, char chopper);
/* Load all adjacency from chopper separated file.
 * Dispose of this with adjacencyFreeList(). */

#define adjacencyLoadAllByTab(a) adjacencyLoadAllByChar(a, '\t');
/* Load all adjacency from tab separated file.
 * Dispose of this with adjacencyFreeList(). */

struct adjacency *adjacencyCommaIn(char **pS, struct adjacency *ret);
/* Create a adjacency out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new adjacency */

void adjacencyFree(struct adjacency **pEl);
/* Free a single dynamically allocated adjacency such as created
 * with adjacencyLoad(). */

void adjacencyFreeList(struct adjacency **pList);
/* Free a list of dynamically allocated adjacency's */

void adjacencyOutput(struct adjacency *el, FILE *f, char sep, char lastSep);
/* Print out adjacency.  Separate fields with sep. Follow last field with lastSep. */

#define adjacencyTabOut(el,f) adjacencyOutput(el,f,'\t','\n');
/* Print out adjacency as a line in a tab-separated file. */

#define adjacencyCommaOut(el,f) adjacencyOutput(el,f,',',',');
/* Print out adjacency as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ADJACENCY_H */

