/* edwAnalysis.h was originally generated by the autoSql program, which also 
 * generated edwAnalysis.c and edwAnalysis.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef EDWANALYSIS_H
#define EDWANALYSIS_H

#include "jksql.h"
#define EDWANALYSISJOB_NUM_COLS 9

extern char *edwAnalysisJobCommaSepFieldNames;

struct edwAnalysisJob
/* An analysis pipeline job to be run asynchronously and not too many all at once. */
    {
    struct edwAnalysisJob *next;  /* Next in singly linked list. */
    unsigned id;	/* Job id */
    char *commandLine;	/* Command line of job */
    long long startTime;	/* Start time in seconds since 1970 */
    long long endTime;	/* End time in seconds since 1970 */
    char *stderr;	/* The output to stderr of the run - may be nonempty even with success */
    int returnCode;	/* The return code from system command - 0 for success */
    int pid;	/* Process ID for running processes */
    int cpusRequested;	/* Number of CPUs to request from job control system */
    char *parasolId;	/* Parasol job id for process. */
    };

void edwAnalysisJobStaticLoad(char **row, struct edwAnalysisJob *ret);
/* Load a row from edwAnalysisJob table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwAnalysisJob *edwAnalysisJobLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwAnalysisJob from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwAnalysisJobFreeList(). */

void edwAnalysisJobSaveToDb(struct sqlConnection *conn, struct edwAnalysisJob *el, char *tableName, int updateSize);
/* Save edwAnalysisJob as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwAnalysisJob *edwAnalysisJobLoad(char **row);
/* Load a edwAnalysisJob from row fetched with select * from edwAnalysisJob
 * from database.  Dispose of this with edwAnalysisJobFree(). */

struct edwAnalysisJob *edwAnalysisJobLoadAll(char *fileName);
/* Load all edwAnalysisJob from whitespace-separated file.
 * Dispose of this with edwAnalysisJobFreeList(). */

struct edwAnalysisJob *edwAnalysisJobLoadAllByChar(char *fileName, char chopper);
/* Load all edwAnalysisJob from chopper separated file.
 * Dispose of this with edwAnalysisJobFreeList(). */

#define edwAnalysisJobLoadAllByTab(a) edwAnalysisJobLoadAllByChar(a, '\t');
/* Load all edwAnalysisJob from tab separated file.
 * Dispose of this with edwAnalysisJobFreeList(). */

struct edwAnalysisJob *edwAnalysisJobCommaIn(char **pS, struct edwAnalysisJob *ret);
/* Create a edwAnalysisJob out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwAnalysisJob */

void edwAnalysisJobFree(struct edwAnalysisJob **pEl);
/* Free a single dynamically allocated edwAnalysisJob such as created
 * with edwAnalysisJobLoad(). */

void edwAnalysisJobFreeList(struct edwAnalysisJob **pList);
/* Free a list of dynamically allocated edwAnalysisJob's */

void edwAnalysisJobOutput(struct edwAnalysisJob *el, FILE *f, char sep, char lastSep);
/* Print out edwAnalysisJob.  Separate fields with sep. Follow last field with lastSep. */

#define edwAnalysisJobTabOut(el,f) edwAnalysisJobOutput(el,f,'\t','\n');
/* Print out edwAnalysisJob as a line in a tab-separated file. */

#define edwAnalysisJobCommaOut(el,f) edwAnalysisJobOutput(el,f,',',',');
/* Print out edwAnalysisJob as a comma separated list including final comma. */

#define EDWANALYSISSOFTWARE_NUM_COLS 4

extern char *edwAnalysisSoftwareCommaSepFieldNames;

struct edwAnalysisSoftware
/* Software that is tracked by the analysis pipeline. */
    {
    struct edwAnalysisSoftware *next;  /* Next in singly linked list. */
    unsigned id;	/* Software id */
    char *name;	/* Command line name */
    char *version;	/* Current version */
    char md5[33];	/* md5 sum of executable file */
    };

void edwAnalysisSoftwareStaticLoad(char **row, struct edwAnalysisSoftware *ret);
/* Load a row from edwAnalysisSoftware table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwAnalysisSoftware *edwAnalysisSoftwareLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwAnalysisSoftware from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwAnalysisSoftwareFreeList(). */

void edwAnalysisSoftwareSaveToDb(struct sqlConnection *conn, struct edwAnalysisSoftware *el, char *tableName, int updateSize);
/* Save edwAnalysisSoftware as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwAnalysisSoftware *edwAnalysisSoftwareLoad(char **row);
/* Load a edwAnalysisSoftware from row fetched with select * from edwAnalysisSoftware
 * from database.  Dispose of this with edwAnalysisSoftwareFree(). */

struct edwAnalysisSoftware *edwAnalysisSoftwareLoadAll(char *fileName);
/* Load all edwAnalysisSoftware from whitespace-separated file.
 * Dispose of this with edwAnalysisSoftwareFreeList(). */

struct edwAnalysisSoftware *edwAnalysisSoftwareLoadAllByChar(char *fileName, char chopper);
/* Load all edwAnalysisSoftware from chopper separated file.
 * Dispose of this with edwAnalysisSoftwareFreeList(). */

#define edwAnalysisSoftwareLoadAllByTab(a) edwAnalysisSoftwareLoadAllByChar(a, '\t');
/* Load all edwAnalysisSoftware from tab separated file.
 * Dispose of this with edwAnalysisSoftwareFreeList(). */

struct edwAnalysisSoftware *edwAnalysisSoftwareCommaIn(char **pS, struct edwAnalysisSoftware *ret);
/* Create a edwAnalysisSoftware out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwAnalysisSoftware */

void edwAnalysisSoftwareFree(struct edwAnalysisSoftware **pEl);
/* Free a single dynamically allocated edwAnalysisSoftware such as created
 * with edwAnalysisSoftwareLoad(). */

void edwAnalysisSoftwareFreeList(struct edwAnalysisSoftware **pList);
/* Free a list of dynamically allocated edwAnalysisSoftware's */

void edwAnalysisSoftwareOutput(struct edwAnalysisSoftware *el, FILE *f, char sep, char lastSep);
/* Print out edwAnalysisSoftware.  Separate fields with sep. Follow last field with lastSep. */

#define edwAnalysisSoftwareTabOut(el,f) edwAnalysisSoftwareOutput(el,f,'\t','\n');
/* Print out edwAnalysisSoftware as a line in a tab-separated file. */

#define edwAnalysisSoftwareCommaOut(el,f) edwAnalysisSoftwareOutput(el,f,',',',');
/* Print out edwAnalysisSoftware as a comma separated list including final comma. */

#define EDWANALYSISSTEP_NUM_COLS 5

extern char *edwAnalysisStepCommaSepFieldNames;

struct edwAnalysisStep
/* A step in an analysis pipeline - something that takes one file to another */
    {
    struct edwAnalysisStep *next;  /* Next in singly linked list. */
    unsigned id;	/* Step id */
    char *name;	/* Name of this analysis step */
    int softwareCount;	/* Number of pieces of software used in step */
    char **software;	/* Names of software used. First is the glue script */
    int cpusRequested;	/* Number of CPUs to request from job control system */
    };

struct edwAnalysisStep *edwAnalysisStepLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwAnalysisStep from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwAnalysisStepFreeList(). */

void edwAnalysisStepSaveToDb(struct sqlConnection *conn, struct edwAnalysisStep *el, char *tableName, int updateSize);
/* Save edwAnalysisStep as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwAnalysisStep *edwAnalysisStepLoad(char **row);
/* Load a edwAnalysisStep from row fetched with select * from edwAnalysisStep
 * from database.  Dispose of this with edwAnalysisStepFree(). */

struct edwAnalysisStep *edwAnalysisStepLoadAll(char *fileName);
/* Load all edwAnalysisStep from whitespace-separated file.
 * Dispose of this with edwAnalysisStepFreeList(). */

struct edwAnalysisStep *edwAnalysisStepLoadAllByChar(char *fileName, char chopper);
/* Load all edwAnalysisStep from chopper separated file.
 * Dispose of this with edwAnalysisStepFreeList(). */

#define edwAnalysisStepLoadAllByTab(a) edwAnalysisStepLoadAllByChar(a, '\t');
/* Load all edwAnalysisStep from tab separated file.
 * Dispose of this with edwAnalysisStepFreeList(). */

struct edwAnalysisStep *edwAnalysisStepCommaIn(char **pS, struct edwAnalysisStep *ret);
/* Create a edwAnalysisStep out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwAnalysisStep */

void edwAnalysisStepFree(struct edwAnalysisStep **pEl);
/* Free a single dynamically allocated edwAnalysisStep such as created
 * with edwAnalysisStepLoad(). */

void edwAnalysisStepFreeList(struct edwAnalysisStep **pList);
/* Free a list of dynamically allocated edwAnalysisStep's */

void edwAnalysisStepOutput(struct edwAnalysisStep *el, FILE *f, char sep, char lastSep);
/* Print out edwAnalysisStep.  Separate fields with sep. Follow last field with lastSep. */

#define edwAnalysisStepTabOut(el,f) edwAnalysisStepOutput(el,f,'\t','\n');
/* Print out edwAnalysisStep as a line in a tab-separated file. */

#define edwAnalysisStepCommaOut(el,f) edwAnalysisStepOutput(el,f,',',',');
/* Print out edwAnalysisStep as a comma separated list including final comma. */

#define EDWANALYSISRUN_NUM_COLS 20

extern char *edwAnalysisRunCommaSepFieldNames;

struct edwAnalysisRun
/* Information on an analysis job that we're planning on running */
    {
    struct edwAnalysisRun *next;  /* Next in singly linked list. */
    unsigned id;	/* Analysis run ID */
    unsigned jobId;	/* ID in edwAnalysisJob table */
    char experiment[17];	/* Something like ENCSR000CFA. */
    char *analysisStep;	/* Name of analysis step */
    char *configuration;	/* Configuration for analysis step */
    char *tempDir;	/* Where analysis is to be computed */
    unsigned firstInputId;	/* ID in edwFile of first input */
    unsigned inputFileCount;	/* Total number of input files */
    unsigned *inputFileIds;	/* list of all input files as fileIds */
    char **inputTypes;	/* List of types to go with input files in json output */
    unsigned assemblyId;	/* Id of assembly we are working with */
    unsigned outputFileCount;	/* Total number of output files */
    char **outputNamesInTempDir;	/* list of all output file names in output dir */
    char **outputFormats;	/* list of formats of output files */
    char **outputTypes;	/* list of formats of output files */
    char *jsonResult;	/* JSON formatted object with result for Stanford metaDatabase */
    char uuid[38];	/* Help to synchronize us with Stanford. */
    signed char createStatus;	/* 1 if output files made 0 if not made, -1 if make tried and failed */
    unsigned createCount;	/* Count of files made */
    unsigned *createFileIds;	/* list of ids of output files in warehouse */
    };

struct edwAnalysisRun *edwAnalysisRunLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwAnalysisRun from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwAnalysisRunFreeList(). */

void edwAnalysisRunSaveToDb(struct sqlConnection *conn, struct edwAnalysisRun *el, char *tableName, int updateSize);
/* Save edwAnalysisRun as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwAnalysisRun *edwAnalysisRunLoad(char **row);
/* Load a edwAnalysisRun from row fetched with select * from edwAnalysisRun
 * from database.  Dispose of this with edwAnalysisRunFree(). */

struct edwAnalysisRun *edwAnalysisRunLoadAll(char *fileName);
/* Load all edwAnalysisRun from whitespace-separated file.
 * Dispose of this with edwAnalysisRunFreeList(). */

struct edwAnalysisRun *edwAnalysisRunLoadAllByChar(char *fileName, char chopper);
/* Load all edwAnalysisRun from chopper separated file.
 * Dispose of this with edwAnalysisRunFreeList(). */

#define edwAnalysisRunLoadAllByTab(a) edwAnalysisRunLoadAllByChar(a, '\t');
/* Load all edwAnalysisRun from tab separated file.
 * Dispose of this with edwAnalysisRunFreeList(). */

struct edwAnalysisRun *edwAnalysisRunCommaIn(char **pS, struct edwAnalysisRun *ret);
/* Create a edwAnalysisRun out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwAnalysisRun */

void edwAnalysisRunFree(struct edwAnalysisRun **pEl);
/* Free a single dynamically allocated edwAnalysisRun such as created
 * with edwAnalysisRunLoad(). */

void edwAnalysisRunFreeList(struct edwAnalysisRun **pList);
/* Free a list of dynamically allocated edwAnalysisRun's */

void edwAnalysisRunOutput(struct edwAnalysisRun *el, FILE *f, char sep, char lastSep);
/* Print out edwAnalysisRun.  Separate fields with sep. Follow last field with lastSep. */

#define edwAnalysisRunTabOut(el,f) edwAnalysisRunOutput(el,f,'\t','\n');
/* Print out edwAnalysisRun as a line in a tab-separated file. */

#define edwAnalysisRunCommaOut(el,f) edwAnalysisRunOutput(el,f,',',',');
/* Print out edwAnalysisRun as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* EDWANALYSIS_H */

