/* transMapInfo.c was originally generated by the autoSql program, which also 
 * generated transMapInfo.h and transMapInfo.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "transMapInfo.h"

/* definitions for chainSubset column */
static char *values_chainSubset[] = {"unknown", "all", "syn", "rbest", NULL};
static struct hash *valhash_chainSubset = NULL;

void transMapInfoStaticLoad(char **row, struct transMapInfo *ret)
/* Load a row from transMapInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->mappedId = row[0];
safecpy(ret->srcDb, sizeof(ret->srcDb), row[1]);
ret->srcId = row[2];
ret->mappingId = row[3];
ret->chainSubset = sqlEnumParse(row[4], values_chainSubset, &valhash_chainSubset);
}

struct transMapInfo *transMapInfoLoad(char **row)
/* Load a transMapInfo from row fetched with select * from transMapInfo
 * from database.  Dispose of this with transMapInfoFree(). */
{
struct transMapInfo *ret;

AllocVar(ret);
ret->mappedId = cloneString(row[0]);
safecpy(ret->srcDb, sizeof(ret->srcDb), row[1]);
ret->srcId = cloneString(row[2]);
ret->mappingId = cloneString(row[3]);
ret->chainSubset = sqlEnumParse(row[4], values_chainSubset, &valhash_chainSubset);
return ret;
}

struct transMapInfo *transMapInfoLoadAll(char *fileName) 
/* Load all transMapInfo from a whitespace-separated file.
 * Dispose of this with transMapInfoFreeList(). */
{
struct transMapInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = transMapInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct transMapInfo *transMapInfoLoadAllByChar(char *fileName, char chopper) 
/* Load all transMapInfo from a chopper separated file.
 * Dispose of this with transMapInfoFreeList(). */
{
struct transMapInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = transMapInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct transMapInfo *transMapInfoCommaIn(char **pS, struct transMapInfo *ret)
/* Create a transMapInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new transMapInfo */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->mappedId = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->srcDb, sizeof(ret->srcDb));
ret->srcId = sqlStringComma(&s);
ret->mappingId = sqlStringComma(&s);
ret->chainSubset = sqlEnumComma(&s, values_chainSubset, &valhash_chainSubset);
*pS = s;
return ret;
}

void transMapInfoFree(struct transMapInfo **pEl)
/* Free a single dynamically allocated transMapInfo such as created
 * with transMapInfoLoad(). */
{
struct transMapInfo *el;

if ((el = *pEl) == NULL) return;
freeMem(el->mappedId);
freeMem(el->srcId);
freeMem(el->mappingId);
freez(pEl);
}

void transMapInfoFreeList(struct transMapInfo **pList)
/* Free a list of dynamically allocated transMapInfo's */
{
struct transMapInfo *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    transMapInfoFree(&el);
    }
*pList = NULL;
}

void transMapInfoOutput(struct transMapInfo *el, FILE *f, char sep, char lastSep) 
/* Print out transMapInfo.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mappedId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->srcDb);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->srcId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mappingId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
sqlEnumPrint(f, el->chainSubset, values_chainSubset);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct transMapInfo *transMapInfoQuery(struct sqlConnection *conn,
                                       char *table, char *mappedId)
/* load a single transMapInfo object for an mapped id from a table,
 * or error if not found */
{
return sqlQueryObjs(conn, (sqlLoadFunc)transMapInfoLoad,
                    sqlQueryMust|sqlQuerySingle,
                    "SELECT mappedId,srcDb,srcId,mappingId,chainSubset FROM %s WHERE mappedId = \"%s\"",
                    table, mappedId);
}
