/* makeItemsItem.c was originally generated by the autoSql program, which also
 * generated makeItemsItem.h and makeItemsItem.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "makeItemsItem.h"


void makeItemsItemStaticLoad(char **row, struct makeItemsItem *ret)
/* Load a row from makeItemsItem table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->bin = sqlUnsigned(row[0]);
ret->chrom = row[1];
ret->chromStart = sqlUnsigned(row[2]);
ret->chromEnd = sqlUnsigned(row[3]);
ret->name = row[4];
ret->score = sqlUnsigned(row[5]);
safecpy(ret->strand, sizeof(ret->strand), row[6]);
ret->thickStart = sqlUnsigned(row[7]);
ret->thickEnd = sqlUnsigned(row[8]);
ret->itemRgb = sqlUnsigned(row[9]);
ret->description = row[10];
ret->id = sqlUnsigned(row[11]);
}

struct makeItemsItem *makeItemsItemLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all makeItemsItem from table that satisfy the query given.
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something =
 * anotherTable.something'.
 * Dispose of this with makeItemsItemFreeList(). */
{
struct makeItemsItem *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = makeItemsItemLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void makeItemsItemSaveToDb(struct sqlConnection *conn, struct makeItemsItem *el, char *tableName, int updateSize)
/* Save makeItemsItem as a row to the table specified by tableName.
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%u,%u,'%s',%u,'%s',%u,%u,%u,%s,%u)",
	tableName,  el->bin,  el->chrom,  el->chromStart,  el->chromEnd,  el->name,  el->score,  el->strand,  el->thickStart,  el->thickEnd,  el->itemRgb,  el->description,  el->id);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}


struct makeItemsItem *makeItemsItemLoad(char **row)
/* Load a makeItemsItem from row fetched with select * from makeItemsItem
 * from database.  Dispose of this with makeItemsItemFree(). */
{
struct makeItemsItem *ret;

AllocVar(ret);
ret->bin = sqlUnsigned(row[0]);
ret->chrom = cloneString(row[1]);
ret->chromStart = sqlUnsigned(row[2]);
ret->chromEnd = sqlUnsigned(row[3]);
ret->name = cloneString(row[4]);
ret->score = sqlUnsigned(row[5]);
safecpy(ret->strand, sizeof(ret->strand), row[6]);
ret->thickStart = sqlUnsigned(row[7]);
ret->thickEnd = sqlUnsigned(row[8]);
ret->itemRgb = sqlUnsigned(row[9]);
ret->description = cloneString(row[10]);
ret->id = sqlUnsigned(row[11]);
return ret;
}

struct makeItemsItem *makeItemsItemLoadAll(char *fileName)
/* Load all makeItemsItem from a whitespace-separated file.
 * Dispose of this with makeItemsItemFreeList(). */
{
struct makeItemsItem *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileRow(lf, row))
    {
    el = makeItemsItemLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct makeItemsItem *makeItemsItemLoadAllByChar(char *fileName, char chopper)
/* Load all makeItemsItem from a chopper separated file.
 * Dispose of this with makeItemsItemFreeList(). */
{
struct makeItemsItem *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = makeItemsItemLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct makeItemsItem *makeItemsItemCommaIn(char **pS, struct makeItemsItem *ret)
/* Create a makeItemsItem out of a comma separated string.
 * This will fill in ret if non-null, otherwise will
 * return a new makeItemsItem */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->bin = sqlUnsignedComma(&s);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->itemRgb = sqlUnsignedComma(&s);
ret->description = sqlStringComma(&s);
ret->id = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void makeItemsItemFree(struct makeItemsItem **pEl)
/* Free a single dynamically allocated makeItemsItem such as created
 * with makeItemsItemLoad(). */
{
struct makeItemsItem *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->description);
freez(pEl);
}

void makeItemsItemFreeList(struct makeItemsItem **pList)
/* Free a list of dynamically allocated makeItemsItem's */
{
struct makeItemsItem *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    makeItemsItemFree(&el);
    }
*pList = NULL;
}

void makeItemsItemOutput(struct makeItemsItem *el, FILE *f, char sep, char lastSep)
/* Print out makeItemsItem.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->bin);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->itemRgb);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->id);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

static char *makeItemsItemAutoSqlString =
"table makeItemsItem\n"
"\"An item in a makeItems type track.\"\n"
"    (\n"
"    uint bin;	       \"Bin for range index\"\n"
"    string chrom;      \"Reference sequence chromosome or scaffold\"\n"
"    uint   chromStart; \"Start position in chromosome\"\n"
"    uint   chromEnd;   \"End position in chromosome\"\n"
"    string name;       \"Name of item - up to 16 chars\"\n"
"    uint  score;	\"0-1000.  Higher numbers are darker.\"\n"
"    char[1] strand;     \"+ or - for strand\"\n"
"    uint   thickStart; \"Start of thick part\"\n"
"    uint   thickEnd;   \"End position of thick part\"\n"
"    uint itemRgb;	\"RGB 8 bits each as in bed\"\n"
"    lstring description; \"Longer item description\"\n"
"    uint id;		\"Unique ID for item\"\n"
"    )\n"
   ;

struct asObject *makeItemsItemAsObj()
// Return asObject describing fields of makeItemsItem
{
return asParseText(makeItemsItemAutoSqlString);
}

