/* mafSummary.c was originally generated by the autoSql program, which also 
 * generated mafSummary.h and mafSummary.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "mafSummary.h"


void mafSummaryStaticLoad(char **row, struct mafSummary *ret)
/* Load a row from mafSummary table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->src = row[3];
ret->score = atof(row[4]);
strcpy(ret->leftStatus, row[5]);
strcpy(ret->rightStatus, row[6]);
}

struct mafSummary *mafSummaryLoad(char **row)
/* Load a mafSummary from row fetched with select * from mafSummary
 * from database.  Dispose of this with mafSummaryFree(). */
{
struct mafSummary *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->src = cloneString(row[3]);
ret->score = atof(row[4]);
strcpy(ret->leftStatus, row[5]);
strcpy(ret->rightStatus, row[6]);
return ret;
}

struct mafSummary *mafSummaryLoadAll(char *fileName) 
/* Load all mafSummary from a whitespace-separated file.
 * Dispose of this with mafSummaryFreeList(). */
{
struct mafSummary *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = mafSummaryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct mafSummary *mafSummaryLoadAllByChar(char *fileName, char chopper) 
/* Load all mafSummary from a chopper separated file.
 * Dispose of this with mafSummaryFreeList(). */
{
struct mafSummary *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = mafSummaryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct mafSummary *mafSummaryLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all mafSummary from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with mafSummaryFreeList(). */
{
struct mafSummary *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = mafSummaryLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void mafSummarySaveToDb(struct sqlConnection *conn, struct mafSummary *el, char *tableName, int updateSize)
/* Save mafSummary as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s',%u,%u,'%s',%g,'%s','%s')", 
	tableName,  el->chrom,  el->chromStart,  el->chromEnd,  el->src,  el->score,  el->leftStatus,  el->rightStatus);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct mafSummary *mafSummaryCommaIn(char **pS, struct mafSummary *ret)
/* Create a mafSummary out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new mafSummary */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->src = sqlStringComma(&s);
ret->score = sqlFloatComma(&s);
sqlFixedStringComma(&s, ret->leftStatus, sizeof(ret->leftStatus));
sqlFixedStringComma(&s, ret->rightStatus, sizeof(ret->rightStatus));
*pS = s;
return ret;
}

void mafSummaryFree(struct mafSummary **pEl)
/* Free a single dynamically allocated mafSummary such as created
 * with mafSummaryLoad(). */
{
struct mafSummary *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->src);
freez(pEl);
}

void mafSummaryFreeList(struct mafSummary **pList)
/* Free a list of dynamically allocated mafSummary's */
{
struct mafSummary *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    mafSummaryFree(&el);
    }
*pList = NULL;
}

void mafSummaryOutput(struct mafSummary *el, FILE *f, char sep, char lastSep) 
/* Print out mafSummary.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->src);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->leftStatus);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rightStatus);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void mafSummaryTableCreate(struct sqlConnection *conn, char *tableName, int indexSize)
/* Create a mafSummary table with the given name
 */
{
char *createString =
"#Positions and scores for alignment blocks\n"
"CREATE TABLE %s (\n"
"       bin smallint unsigned not null,\n"
"       chrom varchar(255) not null,	# Chromosome\n"
"       chromStart int unsigned not null,	# Start position in chromosome\n"
"       chromEnd int unsigned not null,	# End position in chromosome\n"
"       src varchar(255) not null,	# Sequence name or database of alignment\n"
"       score float not null,	# Floating point score (0.0 to 1.0).\n"
"          #Indices\n"
"       leftStatus char(1),     # Status WRT preceding block\n"
"       rightStatus char(1),    # Status WRT following block\n"
"    INDEX(chrom(%d),bin)\n"
")\n";
struct dyString *dy = dyStringNew(1024);
sqlDyStringPrintf(dy, createString, tableName, indexSize, indexSize, indexSize);
sqlRemakeTable(conn, tableName, dy->string);
dyStringFree(&dy);
}

struct mafSummary *mafSummaryMiniLoad(char **row)
/* Load a mafSummary from row fetched with select * from mafSummary
 * from database, except dummy in the {left,right}Status fields.
 * For use on earlier version of mafSummary tables.
 * Dispose of this with mafSummaryFree(). */
{
struct mafSummary *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->src = cloneString(row[3]);
ret->score = atof(row[4]);
return ret;
}
