table hgnc
"A cross-reference table between HUGO Gene Nomenclature Committee (HGNC) IDs and other database IDs."
	(
	string hgncId;	"HGNC ID"
	string symbol;	"Approved Symbol"
	string name;	"Approved Name"
	string status;	"Status"
	string locusType;	"Locus Type"
	string locusGroup;      "Locus Group"
	string prvSymbols;	"Previous Symbols"
	lstring prvNames;	"Previous Names"
	string synonyms;	"Synonyms"
	lstring nameSyns;        "Name synonyms"
	string chrom;		"Reference sequence chromosome or scaffold"
	string dateApprv;	"Date Approved"
	string dateMod;		"Date Modified"
	string dateSymChange;	"Date Symbol Changed"
        string dateNmChange;    "Date Name Changed"
	string accession;	"Accession Numbers"
	string enzymeIds;	"Enzyme IDs"
	string entrezId;	"Entrez Gene ID"
	string ensId;           "Ensembl Gene ID"
	string mgdId;		"MGD ID"
        lstring miscDbs;         "Misc Database Links"
	string miscIds;		"Misc Database IDs"
	string pubMed;		"Pubmed IDs"
	string refSeqIds;	"RefSeq IDs"
	string geneFamilyNm;	"Gene Family Name"
	string geneFamilyDesc;  "Gene Family Description"
        string recType;         "Record Type"
        string primaryId;       "Primary ID"
        string secondaryId;     "Secondary ID"
        string ccdsId;          "CCDS ID"
        string vegaId;          "Vega ID"
        lstring locusDbs;        "Locus-Specific Databases"
        string gdbMapped;       "GDB ID (mapped data)"
	string entrezMapped;	"Entrez Gene ID (mapped data)"
	string omimMapped;	"OMIM ID (mapped data)"
	string refSeqMapped;	"RefSeq (mapped data)"
	string uniProtMapped;	"UniProt ID (mapped data)"
	string ensMapped;       "ENSEMLB ID (mapped data)"
        string ucscMapped;      "UCSC ID (mapped data)"
        string mgiMapped;       "MGD ID (mapped data)"
        string rgdMapped;       "Rat genome database ID (mapped data)"
	)
